/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class MVPrimaryIndex
extends BaseIndex {
    static final ValueLong MIN = ValueLong.get(Long.MIN_VALUE);
    static final ValueLong MAX = ValueLong.get(Long.MAX_VALUE);
    static final ValueLong ZERO = ValueLong.get(0L);
    private final MVTable mvTable;
    private final String mapName;
    private TransactionStore.TransactionMap<Value, Value> dataMap;
    private long lastKey;
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database database, MVTable mVTable, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, mVTable.getName() + "_DATA", indexColumnArray, indexType);
        int[] nArray = new int[indexColumnArray.length];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = 0;
        }
        ValueDataType valueDataType = new ValueDataType(null, null, null);
        ValueDataType valueDataType2 = new ValueDataType(database.getCompareMode(), database, nArray);
        this.mapName = "table." + this.getId();
        this.dataMap = this.mvTable.getTransaction(null).openMap(this.mapName, valueDataType, valueDataType2);
        Value value = this.dataMap.lastKey();
        this.lastKey = value == null ? 0L : value.getLong();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        ValueLong valueLong;
        TransactionStore.TransactionMap<Value, Value> transactionMap;
        Object object;
        Value value;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(++this.lastKey);
            }
        } else {
            long l = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(l);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                value = row.getValue(i);
                object = value.link(this.database, this.getId());
                if (((Value)object).isLinked()) {
                    session.unlinkAtCommitStop((Value)object);
                }
                if (value == object) continue;
                row.setValue(i, (Value)object);
            }
        }
        if ((value = (transactionMap = this.getMap(session)).getLatest(valueLong = ValueLong.get(row.getKey()))) != null) {
            object = "PRIMARY KEY ON " + this.table.getSQL();
            if (this.mainIndexColumn >= 0 && this.mainIndexColumn < this.indexColumns.length) {
                object = (String)object + "(" + this.indexColumns[this.mainIndexColumn].getSQL() + ")";
            }
            DbException dbException = DbException.get(23505, (String)object);
            dbException.setSource(this);
            throw dbException;
        }
        try {
            transactionMap.put(valueLong, ValueArray.get(row.getValueList()));
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, this.table.getName());
        }
        this.lastKey = Math.max(this.lastKey, row.getKey());
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value = row.getValue(i);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit(value);
            }
        }
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(ValueLong.get(row.getKey()));
            if (value == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, this.table.getName());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Object object;
        Object object2 = searchRow == null || this.mainIndexColumn < 0 ? MIN : ((object = (ValueLong)searchRow.getValue(this.mainIndexColumn)) == null ? ZERO : object);
        Object object3 = searchRow2 == null || this.mainIndexColumn < 0 ? MAX : ((object = (ValueLong)searchRow2.getValue(this.mainIndexColumn)) == null ? MAX : object);
        object = this.getMap(session);
        return new MVStoreCursor(((TransactionStore.TransactionMap)object).entryIterator(object2), (ValueLong)object3);
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(Session session, long l) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        Value value = transactionMap.get(ValueLong.get(l));
        ValueArray valueArray = (ValueArray)value;
        Row row = new Row(valueArray.getList(), 0);
        row.setKey(l);
        return row;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter tableFilter, SortOrder sortOrder) {
        try {
            long l = 10L * (this.dataMap.sizeAsLongMax() + 1000L);
            return l;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007);
        }
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueLong valueLong = (ValueLong)(bl ? transactionMap.firstKey() : transactionMap.lastKey());
        if (valueLong == null) {
            return new MVStoreCursor(Collections.emptyList().iterator(), null);
        }
        Value value = transactionMap.get(valueLong);
        DataUtils.MapEntry<ValueLong, Value> mapEntry = new DataUtils.MapEntry<ValueLong, Value>(valueLong, value);
        List<Map.Entry> list = Arrays.asList(mapEntry);
        MVStoreCursor mVStoreCursor = new MVStoreCursor(list.iterator(), valueLong);
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    public long getRowCountMax() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007);
        }
    }

    @Override
    public long getRowCountApproximation() {
        return this.getRowCountMax();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void checkRename() {
    }

    ValueLong getKey(SearchRow searchRow, ValueLong valueLong, ValueLong valueLong2) {
        if (searchRow == null) {
            return valueLong;
        }
        Value value = searchRow.getValue(this.mainIndexColumn);
        if (value == null) {
            throw DbException.throwInternalError(searchRow.toString());
        }
        if (value == ValueNull.INSTANCE) {
            return valueLong2;
        }
        return (ValueLong)value.convertTo(5);
    }

    Cursor find(Session session, ValueLong valueLong, ValueLong valueLong2) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return new MVStoreCursor(transactionMap.entryIterator(valueLong), valueLong2);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(transaction, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Iterator<Map.Entry<Value, Value>> it;
        private final ValueLong last;
        private Map.Entry<Value, Value> current;
        private Row row;

        public MVStoreCursor(Iterator<Map.Entry<Value, Value>> iterator, ValueLong valueLong) {
            this.it = iterator;
            this.last = valueLong;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                ValueArray valueArray = (ValueArray)this.current.getValue();
                this.row = new Row(valueArray.getList(), 0);
                this.row.setKey(this.current.getKey().getLong());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            Map.Entry<Value, Value> entry = this.current = this.it.hasNext() ? this.it.next() : null;
            if (this.current != null && this.current.getKey().getLong() > this.last.getLong()) {
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

