/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private Table table;
    private Sequence sequence;
    private Expression start;
    private Expression increment;
    private Boolean cycle;
    private Expression minValue;
    private Expression maxValue;
    private Expression cacheSize;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null) {
            throw DbException.get(90036, column.getSQL());
        }
    }

    public void setStartWith(Expression expression) {
        this.start = expression;
    }

    public void setIncrement(Expression expression) {
        this.increment = expression;
    }

    public void setCycle(Boolean bl) {
        this.cycle = bl;
    }

    public void setMinValue(Expression expression) {
        this.minValue = expression;
    }

    public void setMaxValue(Expression expression) {
        this.maxValue = expression;
    }

    public void setCacheSize(Expression expression) {
        this.cacheSize = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Object object;
        Object object2;
        Database database = this.session.getDatabase();
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if (this.cycle != null) {
            this.sequence.setCycle(this.cycle);
        }
        if (this.cacheSize != null) {
            long l = this.cacheSize.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setCacheSize(l);
        }
        if (this.start != null || this.minValue != null || this.maxValue != null || this.increment != null) {
            Long l = this.getLong(this.start);
            object2 = this.getLong(this.minValue);
            object = this.getLong(this.maxValue);
            Long l2 = this.getLong(this.increment);
            this.sequence.modify(l, (Long)object2, (Long)object, l2);
        }
        Session session = database.getSystemSession();
        object2 = session;
        synchronized (object2) {
            object = database;
            synchronized (object) {
                database.updateMeta(session, this.sequence);
                session.commit(true);
            }
        }
        return 0;
    }

    private Long getLong(Expression expression) {
        if (expression == null) {
            return null;
        }
        return expression.optimize(this.session).getValue(this.session).getLong();
    }

    @Override
    public int getType() {
        return 54;
    }
}

