/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Comparison;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueNull;

public class ValueExpression
extends Expression {
    private static final Object NULL = new ValueExpression(ValueNull.INSTANCE);
    private static final Object DEFAULT = new ValueExpression(ValueNull.INSTANCE);
    private final Value value;

    private ValueExpression(Value value) {
        this.value = value;
    }

    public static ValueExpression getNull() {
        return (ValueExpression)NULL;
    }

    public static ValueExpression getDefault() {
        return (ValueExpression)DEFAULT;
    }

    public static ValueExpression get(Value value) {
        if (value == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        return new ValueExpression(value);
    }

    @Override
    public Value getValue(Session session) {
        return this.value;
    }

    @Override
    public TypeInfo getType() {
        return this.value.getType();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        if (this.value.getValueType() == 1 && !(bl = ((ValueBoolean)this.value).getBoolean())) {
            tableFilter.addIndexCondition(IndexCondition.get(8, null, this));
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isValueSet() {
        return true;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        if (this == DEFAULT) {
            stringBuilder.append("DEFAULT");
        } else {
            this.value.getSQL(stringBuilder);
        }
        return stringBuilder;
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        int n = this.getType().getValueType();
        if (n == 17 || n == 39) {
            return ValueExpression.getExpressionColumns(session, (ValueCollectionBase)this.getValue(session));
        }
        return super.getExpressionColumns(session);
    }
}

