/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.CChecksum;
import com.hadoop.compression.lzo.DChecksum;
import com.hadoop.compression.lzo.LzoDecompressor;
import com.hadoop.compression.lzo.LzopCodec;
import com.hadoop.compression.lzo.LzopDecompressor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.Decompressor;

public class LzopInputStream
extends BlockDecompressorStream {
    private static final Log LOG = LogFactory.getLog(LzopInputStream.class);
    private final EnumSet<DChecksum> dflags = EnumSet.allOf(DChecksum.class);
    private final EnumSet<CChecksum> cflags = EnumSet.allOf(CChecksum.class);
    private final byte[] buf = new byte[9];
    private final EnumMap<DChecksum, Integer> dcheck = new EnumMap(DChecksum.class);
    private final EnumMap<CChecksum, Integer> ccheck = new EnumMap(CChecksum.class);
    private int noUncompressedBytes = 0;
    private int noCompressedBytes = 0;
    private int uncompressedBlockSize = 0;

    public LzopInputStream(InputStream in, Decompressor decompressor, int bufferSize) throws IOException {
        super(in, decompressor, bufferSize);
        this.readHeader(in);
    }

    private static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException, EOFException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new EOFException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    private static int readInt(InputStream in, byte[] buf, int len) throws IOException {
        LzopInputStream.readFully(in, buf, 0, len);
        int ret = (0xFF & buf[0]) << 24;
        ret |= (0xFF & buf[1]) << 16;
        ret |= (0xFF & buf[2]) << 8;
        return len > 3 ? ret : (ret |= 0xFF & buf[3]) >>> 8 * (4 - len);
    }

    private static int readHeaderItem(InputStream in, byte[] buf, int len, Adler32 adler, CRC32 crc32) throws IOException {
        int ret = LzopInputStream.readInt(in, buf, len);
        adler.update(buf, 0, len);
        crc32.update(buf, 0, len);
        Arrays.fill(buf, (byte)0);
        return ret;
    }

    protected void readHeader(InputStream in) throws IOException {
        boolean bl;
        LzopInputStream.readFully(in, this.buf, 0, 9);
        if (!Arrays.equals(this.buf, LzopCodec.LZO_MAGIC)) {
            throw new IOException("Invalid LZO header");
        }
        Arrays.fill(this.buf, (byte)0);
        Adler32 adler = new Adler32();
        CRC32 crc32 = new CRC32();
        int hitem = LzopInputStream.readHeaderItem(in, this.buf, 2, adler, crc32);
        if (hitem > 4112) {
            LOG.debug((Object)("Compressed with later version of lzop: " + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(4112) + ")"));
        }
        if ((hitem = LzopInputStream.readHeaderItem(in, this.buf, 2, adler, crc32)) < LzoDecompressor.MINIMUM_LZO_VERSION) {
            throw new IOException("Compressed with incompatible lzo version: 0x" + Integer.toHexString(hitem) + " (expected at least 0x" + Integer.toHexString(LzoDecompressor.MINIMUM_LZO_VERSION) + ")");
        }
        hitem = LzopInputStream.readHeaderItem(in, this.buf, 2, adler, crc32);
        if (hitem > 4112) {
            throw new IOException("Compressed with incompatible lzop version: 0x" + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(4112) + ")");
        }
        hitem = LzopInputStream.readHeaderItem(in, this.buf, 1, adler, crc32);
        if (hitem < 1 || hitem > 3) {
            throw new IOException("Invalid strategy: " + Integer.toHexString(hitem));
        }
        LzopInputStream.readHeaderItem(in, this.buf, 1, adler, crc32);
        hitem = LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32);
        try {
            for (DChecksum dChecksum : this.dflags) {
                if (0 == (dChecksum.getHeaderMask() & hitem)) {
                    this.dflags.remove((Object)dChecksum);
                    continue;
                }
                this.dcheck.put(dChecksum, (int)dChecksum.getChecksumClass().newInstance().getValue());
            }
            for (CChecksum cChecksum : this.cflags) {
                if (0 == (cChecksum.getHeaderMask() & hitem)) {
                    this.cflags.remove((Object)cChecksum);
                    continue;
                }
                this.ccheck.put(cChecksum, (int)cChecksum.getChecksumClass().newInstance().getValue());
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Internal error", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error", e);
        }
        ((LzopDecompressor)this.decompressor).initHeaderFlags(this.dflags, this.cflags);
        boolean useCRC32 = 0 != (hitem & 0x1000);
        boolean bl2 = bl = 0 != (hitem & 0x40);
        if (0 != (hitem & 0x400)) {
            throw new IOException("Multipart lzop not supported");
        }
        if (0 != (hitem & 0x800)) {
            throw new IOException("lzop filter not supported");
        }
        if (0 != (hitem & 0xFC000)) {
            throw new IOException("Unknown flags in header");
        }
        LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32);
        LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32);
        LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32);
        hitem = LzopInputStream.readHeaderItem(in, this.buf, 1, adler, crc32);
        if (hitem > 0) {
            int filenameLen = Math.max(4, hitem);
            LzopInputStream.readHeaderItem(in, new byte[filenameLen], hitem, adler, crc32);
        }
        int checksum = (int)(useCRC32 ? crc32.getValue() : adler.getValue());
        hitem = LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32);
        if (hitem != checksum) {
            throw new IOException("Invalid header checksum: " + Long.toHexString(checksum) + " (expected 0x" + Integer.toHexString(hitem) + ")");
        }
        if (bl) {
            LOG.debug((Object)"Extra header field not processed");
            adler.reset();
            crc32.reset();
            hitem = LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32);
            LzopInputStream.readHeaderItem(in, new byte[hitem], hitem, adler, crc32);
            checksum = (int)(useCRC32 ? crc32.getValue() : adler.getValue());
            if (checksum != LzopInputStream.readHeaderItem(in, this.buf, 4, adler, crc32)) {
                throw new IOException("Invalid checksum for extra header field");
            }
        }
    }

    private void verifyChecksums() throws IOException {
        LzopDecompressor ldecompressor = (LzopDecompressor)this.decompressor;
        for (Map.Entry<DChecksum, Integer> entry : this.dcheck.entrySet()) {
            if (ldecompressor.verifyDChecksum(entry.getKey(), entry.getValue())) continue;
            throw new IOException("Corrupted uncompressed block");
        }
        if (!ldecompressor.isCurrentBlockUncompressed()) {
            for (Map.Entry<Enum, Integer> entry : this.ccheck.entrySet()) {
                if (ldecompressor.verifyCChecksum((CChecksum)entry.getKey(), entry.getValue())) continue;
                throw new IOException("Corrupted compressed block");
            }
        }
    }

    protected int decompress(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.noUncompressedBytes == this.uncompressedBlockSize) {
            try {
                byte[] tempBuf = new byte[4];
                this.uncompressedBlockSize = LzopInputStream.readInt(this.in, tempBuf, 4);
                this.noCompressedBytes += 4;
            }
            catch (EOFException e) {
                this.eof = true;
                return -1;
            }
            this.noUncompressedBytes = 0;
        }
        int n = 0;
        while ((n = this.decompressor.decompress(b, off, len)) == 0) {
            if ((this.decompressor.finished() || this.decompressor.needsDictionary()) && this.noUncompressedBytes >= this.uncompressedBlockSize) {
                this.eof = true;
                return -1;
            }
            if (!this.decompressor.needsInput()) continue;
            try {
                this.getCompressedData();
            }
            catch (EOFException e) {
                this.eof = true;
                return -1;
            }
            catch (IOException e) {
                LOG.warn((Object)"IOException in getCompressedData; likely LZO corruption.", (Throwable)e);
                throw e;
            }
        }
        this.noUncompressedBytes += n;
        return n;
    }

    protected int getCompressedData() throws IOException {
        this.checkStream();
        this.verifyChecksums();
        int compressedLen = LzopInputStream.readInt(this.in, this.buf, 4);
        this.noCompressedBytes += 4;
        if (compressedLen > 0x4000000) {
            throw new IOException("Compressed length " + compressedLen + " exceeds max block size " + 0x4000000 + " (probably corrupt file)");
        }
        LzopDecompressor ldecompressor = (LzopDecompressor)this.decompressor;
        ldecompressor.setCurrentBlockUncompressed(compressedLen >= this.uncompressedBlockSize);
        for (DChecksum dChecksum : this.dcheck.keySet()) {
            this.dcheck.put(dChecksum, LzopInputStream.readInt(this.in, this.buf, 4));
            this.noCompressedBytes += 4;
        }
        if (!ldecompressor.isCurrentBlockUncompressed()) {
            for (CChecksum cChecksum : this.ccheck.keySet()) {
                this.ccheck.put(cChecksum, LzopInputStream.readInt(this.in, this.buf, 4));
                this.noCompressedBytes += 4;
            }
        }
        ldecompressor.resetChecksum();
        if (compressedLen > this.buffer.length) {
            this.buffer = new byte[compressedLen];
        }
        LzopInputStream.readFully(this.in, this.buffer, 0, compressedLen);
        this.noCompressedBytes += compressedLen;
        ldecompressor.setInput(this.buffer, 0, compressedLen);
        return compressedLen;
    }

    public long getCompressedBytesRead() {
        return this.noCompressedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        byte[] b = new byte[4096];
        while (!this.decompressor.finished()) {
            this.decompressor.decompress(b, 0, b.length);
        }
        super.close();
        try {
            this.verifyChecksums();
        }
        catch (IOException e) {
            LOG.warn((Object)"Incorrect LZO file format: file did not end with four trailing zeroes.", (Throwable)e);
        }
        finally {
            CodecPool.returnDecompressor((Decompressor)this.decompressor);
        }
    }
}

