/*
 * Decompiled with CFR 0.152.
 */
package com.homeaway.devtools.jenkins.testing;

import com.homeaway.devtools.jenkins.testing.APipelineExtensionDetector;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProjectPipelineExtensionDetector
extends APipelineExtensionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(LocalProjectPipelineExtensionDetector.class);

    @Override
    public Set<Class<?>> getClassesOfTypeInPackage(Class<?> _supertype, Optional<String> _package) {
        HashSet classes = new HashSet();
        HashMap<String, ClassNotFoundException> failures = new HashMap<String, ClassNotFoundException>();
        Reflections reflector = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false)}).setUrls(ClasspathHelper.forPackage((String)_package.orElse(""), (ClassLoader[])new ClassLoader[0])));
        Set all_types = new HashSet();
        try {
            all_types = reflector.getAllTypes();
        }
        catch (ReflectionsException re) {
            if (re.getMessage().contains("Couldn't find subtypes of Object.")) {
                LOG.info("Looks like there aren't any classes compiled by this project.");
            }
            throw re;
        }
        for (String string : all_types) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException e) {
                failures.put(string, e);
                continue;
            }
            classes.add(clazz);
        }
        if (failures.size() > 0) {
            if ("true".equals(System.getProperty("PipelineExtensionDetector.expandFailures"))) {
                for (Map.Entry entry : failures.entrySet()) {
                    LOG.error((String)entry.getKey(), (Throwable)entry.getValue());
                }
            } else {
                LOG.error("Failed to get some classes of type [{}] in package [{}]. For detailed error messages, set the system property PipelineExtensionDetector.expandFailures=true. Failures: [{}]", new Object[]{_supertype, _package, failures.keySet()});
            }
        }
        return classes;
    }

    @Override
    public Set<Class<?>> getClassesWithAnnotationOfTypeInPackage(Class<? extends Annotation> _annotation, Class<?> _supertype, Optional<String> _package) {
        HashSet annotated_classes = new HashSet();
        for (Class annotated_class : new Reflections(_package.orElse(""), new Scanner[0]).getTypesAnnotatedWith(_annotation)) {
            if (!_supertype.isAssignableFrom(annotated_class)) continue;
            annotated_classes.add(annotated_class);
        }
        return annotated_classes;
    }
}

