/*
 * Decompiled with CFR 0.152.
 */
package com.homeaway.devtools.jenkins.testing;

import com.homeaway.devtools.jenkins.testing.APipelineExtensionDetector;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WholeClasspathPipelineExtensionDetector
extends APipelineExtensionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(WholeClasspathPipelineExtensionDetector.class);

    @Override
    public Set<Class<?>> getClassesOfTypeInPackage(Class<?> _supertype, Optional<String> _package) {
        HashSet classes = new HashSet();
        List classnames = new FastClasspathScanner(new String[]{_package.orElse("")}).scan().getNamesOfAllStandardClasses();
        HashMap<String, Throwable> failures = new HashMap<String, Throwable>();
        for (String string : classnames) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException e) {
                failures.put(string, e);
                continue;
            }
            catch (Throwable t) {
                failures.put(string, t);
                continue;
            }
            if (!_supertype.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
        }
        if (failures.size() > 0) {
            if ("true".equals(System.getProperty("PipelineExtensionDetector.expandFailures"))) {
                for (Map.Entry entry : failures.entrySet()) {
                    LOG.error((String)entry.getKey(), (Throwable)entry.getValue());
                }
            } else {
                LOG.warn("Failed to get some classes of type [{}] in package [{}]. For detailed error messages, set the system property PipelineExtensionDetector.expandFailures=true. Failures: [{}]", new Object[]{_supertype, _package, failures.keySet()});
            }
        }
        return classes;
    }

    @Override
    public Set<Class<?>> getClassesWithAnnotationOfTypeInPackage(Class<? extends Annotation> _annotation, Class<?> _supertype, Optional<String> _package) {
        HashSet annotated_classes = new HashSet();
        HashMap<String, Throwable> failures = new HashMap<String, Throwable>();
        List annotated_classnames = new FastClasspathScanner(new String[]{_package.orElse("")}).scan().getNamesOfClassesWithAnnotation(_annotation);
        for (String string : annotated_classnames) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException e) {
                failures.put(string, e);
                continue;
            }
            catch (Throwable t) {
                failures.put(string, t);
                continue;
            }
            if (!_supertype.isAssignableFrom(clazz)) continue;
            annotated_classes.add(clazz);
        }
        if (failures.size() > 0) {
            if ("true".equals(System.getProperty("PipelineExtensionDetector.expandFailures"))) {
                for (Map.Entry entry : failures.entrySet()) {
                    LOG.error((String)entry.getKey(), (Throwable)entry.getValue());
                }
            } else {
                LOG.warn("Failed to get some classes annotated with [{}] of type [{}] in package [{}]. For detailed error messages, set the system property PipelineExtensionDetector.expandFailures=true. Failures: [{}]", new Object[]{_annotation, _supertype, _package, failures.keySet()});
            }
        }
        return annotated_classes;
    }
}

