/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class EcsSecurityUtils {
    private static final String OPENSTACK_METADATA_ROOT = "/openstack/latest";
    private static final String ECS_METADATA_SERIVCE_URL = "http://169.254.169.254";
    private static final String EC2_METADATA_SERVICE_OVERRIDE_URL = "ecsMetadataServiceOverrideEndpoint";
    private static final long HTTP_CONNECT_TIMEOUT_VALUE = 30000L;
    private static OkHttpClient httpClient = new OkHttpClient.Builder().followRedirects(false).retryOnConnectionFailure(true).cache(null).connectTimeout(30000L, TimeUnit.MILLISECONDS).writeTimeout(30000L, TimeUnit.MILLISECONDS).readTimeout(30000L, TimeUnit.MILLISECONDS).build();

    public static String getSecurityKeyInfoWithDetail() throws IOException {
        return EcsSecurityUtils.getResourceWithDetail(EcsSecurityUtils.getEndpointForECSMetadataService() + OPENSTACK_METADATA_ROOT + "/securitykey");
    }

    public static String getEndpointForECSMetadataService() {
        String overridUrl = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE_URL);
        return overridUrl != null ? overridUrl : ECS_METADATA_SERIVCE_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceWithDetail(String endpoint) throws IOException {
        Request.Builder builder = new Request.Builder();
        builder.header("Accept", "*/*");
        Request request = builder.url(endpoint).get().build();
        Call c = httpClient.newCall(request);
        String content = "";
        try (Response res = null;){
            res = c.execute();
            String header = "";
            if (res.headers() != null) {
                header = res.headers().toString();
            }
            if (res.body() != null) {
                content = res.body().string();
            }
            if (res.code() < 200 || res.code() >= 300) {
                String errorMessage = "Get securityKey form ECS failed, Code : " + res.code() + "; Headers : " + header + "; Content : " + content;
                throw new IllegalArgumentException(errorMessage);
            }
            String string = content;
            return string;
        }
    }
}

