/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.IObsCredentialsProvider;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.model.ISecurityKey;

public class BasicObsCredentialsProvider
implements IObsCredentialsProvider {
    private volatile ISecurityKey securityKey;

    public BasicObsCredentialsProvider(ISecurityKey securityKey) {
        this.checkISecurityKey(securityKey);
        this.securityKey = securityKey;
    }

    public BasicObsCredentialsProvider(String accessKey, String secretKey) {
        this(accessKey, secretKey, null);
    }

    public BasicObsCredentialsProvider(String accessKey, String secretKey, String securityToken) {
        BasicObsCredentialsProvider.checkSecurityKey(accessKey, secretKey);
        this.securityKey = new BasicSecurityKey(accessKey, secretKey, securityToken);
    }

    private static void checkSecurityKey(String accessKey, String secretKey) {
        if (accessKey == null) {
            throw new ObsException("accessKey should not be null.");
        }
        if (secretKey == null) {
            throw new ObsException("secretKey should not be null.");
        }
    }

    @Override
    public void setSecurityKey(ISecurityKey securityKey) {
        this.checkISecurityKey(securityKey);
        this.securityKey = securityKey;
    }

    private void checkISecurityKey(ISecurityKey securityKey) {
        if (securityKey == null) {
            throw new IllegalArgumentException("securityKey should not be null.");
        }
        BasicObsCredentialsProvider.checkSecurityKey(securityKey.getAccessKey(), securityKey.getSecretKey());
    }

    @Override
    public ISecurityKey getSecurityKey() {
        if (this.securityKey == null) {
            throw new IllegalArgumentException("Invalid securityKey");
        }
        return this.securityKey;
    }
}

