/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.crypto;

import com.obs.services.crypto.CTRCipherGenerator;
import com.obs.services.exception.ObsException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CtrRSACipherGenerator
extends CTRCipherGenerator {
    public static final String ENCRYPTED_AES_KEY_META_NAME = "encrypted-object-key";
    protected static final String CIPHER_RSA_ALGORITHM = "RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING";
    protected static final String KEY_FACTORY_RSA_ALGORITHM = "RSA";
    private static String RsaCipherProvider = "";
    public static final String ENCRYPTED_ALGORITHM = "AES256-Ctr/iv_base64/NoPadding RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING";
    public static final int MIN_RSA_KEY_LENGTH = 3072;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public CtrRSACipherGenerator(String masterKeyInfo, boolean needSha256, SecureRandom secureRandom, PrivateKey privateKey, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, ObsException {
        super(masterKeyInfo, null, null, needSha256, secureRandom);
        CtrRSACipherGenerator.checkKeyLength(privateKey);
        CtrRSACipherGenerator.checkKeyLength(publicKey);
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static void checkKeyLength(Key key) throws ObsException {
        RSAPublicKey rsaPublicKey;
        int rsaPublicKeyBitLength;
        RSAPrivateKey rsaPrivateKey;
        int rsaPrivateKeyBitLength;
        if (key instanceof RSAPrivateKey && (rsaPrivateKeyBitLength = (rsaPrivateKey = (RSAPrivateKey)key).getModulus().bitLength()) < 3072) {
            String errorMsg = "Your RSAPrivateKey bitLength is " + rsaPrivateKeyBitLength + ", for data safety, please use RSAKeyPair with at least " + 3072 + " bitLength";
            throw new ObsException(errorMsg);
        }
        if (key instanceof RSAPublicKey && (rsaPublicKeyBitLength = (rsaPublicKey = (RSAPublicKey)key).getModulus().bitLength()) < 3072) {
            String errorMsg = "Your RSAPublicKey bitLength is " + rsaPublicKeyBitLength + ", for data safety, please use RSAKeyPair with at least " + 3072 + " bitLength";
            throw new ObsException(errorMsg);
        }
    }

    public static PrivateKey importPKCS8PrivateKey(String filePath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line;
            boolean startKey = false;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("-----BEGIN PRIVATE KEY-----")) {
                    startKey = true;
                    continue;
                }
                if (line.startsWith("-----END PRIVATE KEY-----")) {
                    startKey = false;
                    continue;
                }
                if (!startKey) continue;
                sb.append(line);
            }
        }
        byte[] keyBytes = Base64.getDecoder().decode(sb.toString());
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(KEY_FACTORY_RSA_ALGORITHM);
        return kf.generatePrivate(spec);
    }

    public static PublicKey importPublicKey(String filename) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            String line;
            boolean startKey = false;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("-----BEGIN PUBLIC KEY-----")) {
                    startKey = true;
                    continue;
                }
                if (line.startsWith("-----END PUBLIC KEY-----")) {
                    startKey = false;
                    continue;
                }
                if (!startKey) continue;
                sb.append(line);
            }
        }
        byte[] keyBytes = Base64.getDecoder().decode(sb.toString());
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(KEY_FACTORY_RSA_ALGORITHM);
        return kf.generatePublic(spec);
    }

    public byte[] RSAEncrypted(byte[] plaintext) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        Cipher cipher = CtrRSACipherGenerator.getRsaCipher();
        cipher.init(1, this.publicKey);
        return cipher.doFinal(plaintext);
    }

    public byte[] RSADecrypted(byte[] cipherInfo) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        Cipher cipher = CtrRSACipherGenerator.getRsaCipher();
        cipher.init(2, this.privateKey);
        return cipher.doFinal(cipherInfo);
    }

    public static Cipher getRsaCipher() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        return RsaCipherProvider.equals("") ? Cipher.getInstance(CIPHER_RSA_ALGORITHM) : Cipher.getInstance(CIPHER_RSA_ALGORITHM, RsaCipherProvider);
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public static String getRsaCipherProvider() {
        return RsaCipherProvider;
    }

    public static void setRsaCipherProvider(String rsaCipherProvider) {
        RsaCipherProvider = rsaCipherProvider;
    }
}

