/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ConcurrentProgressManager;
import com.obs.services.internal.ProgressManager;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.CRC64;
import com.obs.services.internal.utils.CRC64InputStream;
import com.obs.services.internal.utils.SecureObjectInputStream;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.PartEtag;
import com.obs.services.model.UploadFileRequest;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class UploadResumableClient {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");
    private AbstractClient obsClient;

    public UploadResumableClient(AbstractClient obsClient) {
        this.obsClient = obsClient;
    }

    public CompleteMultipartUploadResult uploadFileResume(UploadFileRequest uploadFileRequest) {
        ServiceUtils.assertParameterNotNull(uploadFileRequest, "UploadFileRequest is null");
        ServiceUtils.assertParameterNotNull(uploadFileRequest.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(uploadFileRequest.getObjectKey(), "objectKey is null");
        ServiceUtils.assertParameterNotNull(uploadFileRequest.getUploadFile(), "uploadfile is null");
        if (uploadFileRequest.isEnableCheckpoint() && !ServiceUtils.isValid(uploadFileRequest.getCheckpointFile())) {
            uploadFileRequest.setCheckpointFile(uploadFileRequest.getUploadFile() + ".uploadFile_record");
        }
        if (uploadFileRequest.getCallback() != null) {
            ServiceUtils.assertParameterNotNull(uploadFileRequest.getCallback().getCallbackUrl(), "callbackUrl is null");
            ServiceUtils.assertParameterNotNull(uploadFileRequest.getCallback().getCallbackBody(), "callbackBody is null");
        }
        try {
            return this.uploadFileCheckPoint(uploadFileRequest);
        }
        catch (ServiceException e) {
            throw ServiceUtils.changeFromServiceException(e);
        }
        catch (Exception e) {
            throw ServiceUtils.changeFromException(e);
        }
    }

    protected void abortMultipartUploadSilent(String uploadId, UploadFileRequest uploadFileRequest) {
        block2: {
            try {
                this.abortMultipartUpload(uploadId, uploadFileRequest);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Abort multipart upload failed", e);
            }
        }
    }

    protected HeaderResponse abortMultipartUpload(String uploadId, UploadFileRequest uploadFileRequest) {
        AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey(), uploadId);
        request.setRequesterPays(uploadFileRequest.isRequesterPays());
        request.setUserHeaders(uploadFileRequest.getUserHeaders());
        return this.obsClient.abortMultipartUpload(request);
    }

    private void abortUploadFileTaskIfCanceledAndAborted(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) {
        if (uploadFileRequest.getCancelHandler() != null && uploadFileRequest.getCancelHandler().isCancelled() && uploadFileRequest.isNeedAbortUploadFileAfterCancel()) {
            log.error("aborted uploadFileRequest after canceled");
            this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
            ServiceUtils.deleteFileIgnoreException(uploadFileRequest.getCheckpointFile());
        }
    }

    private CRC64 tryGetCombinedCRC64(UploadCheckPoint uploadCheckPoint) {
        if (!uploadCheckPoint.partCRC64s.isEmpty()) {
            try {
                CRC64 crc64Combined = new CRC64(uploadCheckPoint.partCRC64s.get(1));
                for (int i = 2; i <= uploadCheckPoint.partCRC64s.size(); ++i) {
                    crc64Combined.combineWithAnotherCRC64(uploadCheckPoint.partCRC64s.get(i), uploadCheckPoint.uploadParts.get((int)(i - 1)).size);
                }
                return crc64Combined;
            }
            catch (Throwable t) {
                log.error("tryGetCombinedCRC64 for uploadFile failed, throwable:", t);
                throw ServiceUtils.changeFromThrowable(t);
            }
        }
        return null;
    }

    private CompleteMultipartUploadResult uploadFileCheckPoint(UploadFileRequest uploadFileRequest) throws Exception {
        UploadCheckPoint uploadCheckPoint = new UploadCheckPoint();
        if (uploadFileRequest.isEnableCheckpoint()) {
            this.prepareWithCheckpoint(uploadFileRequest, uploadCheckPoint);
        } else {
            this.prepare(uploadFileRequest, uploadCheckPoint);
        }
        List<PartResult> partResults = this.uploadfile(uploadFileRequest, uploadCheckPoint);
        for (PartResult partResult : partResults) {
            if (!partResult.isFailed() || partResult.getException() == null) continue;
            if (!uploadFileRequest.isEnableCheckpoint()) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
            } else if (uploadCheckPoint.isAbort) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
                if (uploadCheckPoint.isDeleteUploadRecordFile) {
                    ServiceUtils.deleteFileIgnoreException(uploadFileRequest.getCheckpointFile());
                }
            } else {
                this.abortUploadFileTaskIfCanceledAndAborted(uploadCheckPoint, uploadFileRequest);
            }
            throw partResult.getException();
        }
        if (uploadFileRequest.getCancelHandler() != null && uploadFileRequest.getCancelHandler().isCancelled()) {
            log.warn("uploadFileRequest is canceled");
            this.abortUploadFileTaskIfCanceledAndAborted(uploadCheckPoint, uploadFileRequest);
            throw new ObsException("uploadFileRequest is canceled, no completeMultipartUploadRequest is sent");
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey(), uploadCheckPoint.uploadID, uploadCheckPoint.partEtags);
        completeMultipartUploadRequest.setRequesterPays(uploadFileRequest.isRequesterPays());
        completeMultipartUploadRequest.setEncodingType(uploadFileRequest.getEncodingType());
        completeMultipartUploadRequest.setIsIgnorePort(uploadFileRequest.getIsIgnorePort());
        completeMultipartUploadRequest.setCallback(uploadFileRequest.getCallback());
        completeMultipartUploadRequest.setUserHeaders(uploadFileRequest.getUserHeaders());
        completeMultipartUploadRequest.setCancelHandler(uploadFileRequest.getCancelHandler());
        CRC64 crc64Combined = this.tryGetCombinedCRC64(uploadCheckPoint);
        if (crc64Combined != null) {
            completeMultipartUploadRequest.setUserHeaders(new HashMap<String, String>(uploadFileRequest.getUserHeaders()));
            completeMultipartUploadRequest.addUserHeaders(this.obsClient.getRestHeaderPrefix(uploadFileRequest.getBucketName()) + "checksum-crc64ecma", crc64Combined.toString());
        }
        try {
            CompleteMultipartUploadResult result = this.obsClient.completeMultipartUpload(completeMultipartUploadRequest);
            if (uploadFileRequest.isEnableCheckpoint()) {
                ServiceUtils.deleteFileIgnoreException(uploadFileRequest.getCheckpointFile());
            }
            return result;
        }
        catch (ObsException e) {
            if (!uploadFileRequest.isEnableCheckpoint()) {
                this.abortMultipartUpload(uploadCheckPoint.uploadID, uploadFileRequest);
            } else if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
                ServiceUtils.deleteFileIgnoreException(uploadFileRequest.getCheckpointFile());
            } else {
                this.abortUploadFileTaskIfCanceledAndAborted(uploadCheckPoint, uploadFileRequest);
            }
            throw e;
        }
    }

    private void prepareWithCheckpoint(UploadFileRequest uploadFileRequest, UploadCheckPoint uploadCheckPoint) throws IOException, Exception {
        boolean needRecreate = false;
        try {
            uploadCheckPoint.load(uploadFileRequest.getCheckpointFile());
        }
        catch (Exception e) {
            needRecreate = true;
        }
        if (!needRecreate) {
            if (!(uploadFileRequest.getBucketName().equals(uploadCheckPoint.bucketName) && uploadFileRequest.getObjectKey().equals(uploadCheckPoint.objectKey) && uploadFileRequest.getUploadFile().equals(uploadCheckPoint.uploadFile))) {
                needRecreate = true;
            } else if (!uploadCheckPoint.isValid(uploadFileRequest.getUploadFile())) {
                needRecreate = true;
            }
        }
        if (needRecreate) {
            if (uploadCheckPoint.bucketName != null && uploadCheckPoint.objectKey != null && uploadCheckPoint.uploadID != null) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
            }
            ServiceUtils.deleteFileIgnoreException(uploadFileRequest.getCheckpointFile());
            this.prepare(uploadFileRequest, uploadCheckPoint);
        }
    }

    private List<PartResult> uploadfile(UploadFileRequest uploadFileRequest, UploadCheckPoint uploadCheckPoint) throws Exception {
        ArrayList<PartResult> pieceResults = new ArrayList<PartResult>();
        ExecutorService executorService = Executors.newFixedThreadPool(uploadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ProgressManager progressManager = null;
        if (uploadFileRequest.getProgressListener() == null) {
            for (int i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
                UploadPart uploadPart = uploadCheckPoint.uploadParts.get(i);
                if (uploadPart.isCompleted) {
                    PartResult pr = new PartResult(uploadPart.partNumber, uploadPart.offset, uploadPart.size);
                    pr.setFailed(false);
                    pieceResults.add(pr);
                    continue;
                }
                futures.add(executorService.submit(new Mission(i, uploadCheckPoint, i, uploadFileRequest, this.obsClient)));
            }
        } else {
            long transferredBytes = 0L;
            LinkedList<Mission> unfinishedUploadMissions = new LinkedList<Mission>();
            for (int i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
                UploadPart uploadPart = uploadCheckPoint.uploadParts.get(i);
                if (uploadPart.isCompleted) {
                    PartResult pr = new PartResult(uploadPart.partNumber, uploadPart.offset, uploadPart.size);
                    pr.setFailed(false);
                    pieceResults.add(pr);
                    transferredBytes += uploadPart.size;
                    continue;
                }
                unfinishedUploadMissions.add(new Mission(i, uploadCheckPoint, i, uploadFileRequest, this.obsClient));
            }
            progressManager = new ConcurrentProgressManager(uploadCheckPoint.uploadFileStatus.size, transferredBytes, uploadFileRequest.getProgressListener(), uploadFileRequest.getProgressInterval() > 0L ? uploadFileRequest.getProgressInterval() : 102400L);
            for (Mission mission : unfinishedUploadMissions) {
                mission.setProgressManager(progressManager);
                futures.add(executorService.submit(mission));
            }
        }
        executorService.shutdown();
        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                pieceResults.add(tr);
            }
            catch (ExecutionException e) {
                if (!uploadFileRequest.isEnableCheckpoint()) {
                    this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
                }
                throw e;
            }
        }
        if (progressManager != null) {
            progressManager.progressEnd();
        }
        return pieceResults;
    }

    private void prepare(UploadFileRequest uploadFileRequest, UploadCheckPoint uploadCheckPoint) throws Exception {
        uploadCheckPoint.uploadFile = uploadFileRequest.getUploadFile();
        uploadCheckPoint.bucketName = uploadFileRequest.getBucketName();
        uploadCheckPoint.objectKey = uploadFileRequest.getObjectKey();
        uploadCheckPoint.uploadFileStatus = FileStatus.getFileStatus(uploadCheckPoint.uploadFile, uploadFileRequest.isEnableCheckSum());
        uploadCheckPoint.uploadParts = this.splitUploadFile(uploadCheckPoint.uploadFileStatus.size, uploadFileRequest.getPartSize());
        uploadCheckPoint.partEtags = new ArrayList();
        uploadCheckPoint.partCRC64s = new ConcurrentHashMap();
        InitiateMultipartUploadRequest initiateUploadRequest = new InitiateMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
        initiateUploadRequest.setExtensionPermissionMap(uploadFileRequest.getExtensionPermissionMap());
        initiateUploadRequest.setAcl(uploadFileRequest.getAcl());
        initiateUploadRequest.setSuccessRedirectLocation(uploadFileRequest.getSuccessRedirectLocation());
        initiateUploadRequest.setSseCHeader(uploadFileRequest.getSseCHeader());
        initiateUploadRequest.setSseKmsHeader(uploadFileRequest.getSseKmsHeader());
        initiateUploadRequest.setMetadata(uploadFileRequest.getObjectMetadata());
        initiateUploadRequest.setRequesterPays(uploadFileRequest.isRequesterPays());
        initiateUploadRequest.setEncodingType(uploadFileRequest.getEncodingType());
        initiateUploadRequest.setIsEncodeHeaders(uploadFileRequest.isEncodeHeaders());
        initiateUploadRequest.setUserHeaders(uploadFileRequest.getUserHeaders());
        initiateUploadRequest.setCancelHandler(uploadFileRequest.getCancelHandler());
        InitiateMultipartUploadResult initiateUploadResult = this.obsClient.initiateMultipartUpload(initiateUploadRequest);
        uploadCheckPoint.uploadID = initiateUploadResult.getUploadId();
        if (uploadFileRequest.isEnableCheckpoint()) {
            try {
                uploadCheckPoint.record(uploadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest);
                throw e;
            }
        }
    }

    private ArrayList<UploadPart> splitUploadFile(long size, long partSize) {
        ArrayList<UploadPart> parts = new ArrayList<UploadPart>();
        long partNum = size / partSize;
        if (partNum >= 10000L) {
            partSize = size % 10000L == 0L ? size / 10000L : size / 10000L + 1L;
            partNum = size / partSize;
        }
        if (size % partSize > 0L) {
            ++partNum;
        }
        if (partNum == 0L) {
            UploadPart part = new UploadPart();
            part.partNumber = 1;
            part.offset = 0L;
            part.size = 0L;
            part.isCompleted = false;
            parts.add(part);
        } else {
            for (long i = 0L; i < partNum; ++i) {
                UploadPart part = new UploadPart();
                part.partNumber = (int)(i + 1L);
                part.offset = i * partSize;
                part.size = partSize;
                part.isCompleted = false;
                parts.add(part);
            }
            if (size % partSize > 0L) {
                parts.get((int)(parts.size() - 1)).size = size % partSize;
            }
        }
        return parts;
    }

    static class PartResult {
        private int partNumber;
        private long offset;
        private long length;
        private boolean isFailed;
        private Exception exception;

        public PartResult(int partNumber, long offset, long length) {
            this.partNumber = partNumber;
            this.offset = offset;
            this.length = length;
        }

        public int getpartNumber() {
            return this.partNumber;
        }

        public void setpartNumber(int partNumber) {
            this.partNumber = partNumber;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public boolean isFailed() {
            return this.isFailed;
        }

        public void setFailed(boolean isFailed) {
            this.isFailed = isFailed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    static class UploadPart
    implements Serializable {
        private static final long serialVersionUID = 751520598820222785L;
        public int partNumber;
        public long offset;
        public long size;
        public boolean isCompleted;

        UploadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isCompleted ? 1 : 0);
            result = 31 * result + this.partNumber;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof UploadPart) {
                UploadPart uploadPart = (UploadPart)obj;
                return uploadPart.hashCode() == obj.hashCode();
            }
            return false;
        }
    }

    static class FileStatus
    implements Serializable {
        private static final long serialVersionUID = -3135754191745936521L;
        public long size;
        public long lastModified;
        public String checkSum;

        FileStatus() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.checkSum == null ? 0 : this.checkSum.hashCode());
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof FileStatus) {
                FileStatus fileStatus = (FileStatus)obj;
                return fileStatus.hashCode() == obj.hashCode();
            }
            return false;
        }

        public static FileStatus getFileStatus(String uploadFile, boolean checkSum) throws IOException {
            FileStatus fileStatus = new FileStatus();
            File file = new File(uploadFile);
            fileStatus.size = file.length();
            fileStatus.lastModified = file.lastModified();
            if (checkSum) {
                try {
                    fileStatus.checkSum = ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(file)));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ObsException("computeMD5Hash failed.", e);
                }
            }
            return fileStatus;
        }
    }

    static class UploadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 5564757792864743464L;
        public int md5;
        public String uploadFile;
        public FileStatus uploadFileStatus;
        public String bucketName;
        public String objectKey;
        public String uploadID;
        public ArrayList<UploadPart> uploadParts;
        public ArrayList<PartEtag> partEtags;
        public ConcurrentHashMap<Integer, CRC64> partCRC64s;
        public volatile transient boolean isAbort = false;
        public volatile transient boolean isDeleteUploadRecordFile = true;

        UploadCheckPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(String checkPointFile) throws Exception {
            FileInputStream fileInput = null;
            ObjectInputStream in = null;
            try {
                fileInput = new FileInputStream(checkPointFile);
                in = new SecureObjectInputStream(fileInput);
                UploadCheckPoint tmp = (UploadCheckPoint)in.readObject();
                this.assign(tmp);
            }
            finally {
                block15: {
                    block14: {
                        if (null != in) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                if (!log.isWarnEnabled()) break block14;
                                log.warn("close failed.", e);
                            }
                        }
                    }
                    if (null != fileInput) {
                        try {
                            fileInput.close();
                        }
                        catch (IOException e) {
                            if (!log.isWarnEnabled()) break block15;
                            log.warn("close failed.", e);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void record(String checkPointFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOutput = null;
            ObjectOutputStream outStream = null;
            try {
                fileOutput = new FileOutputStream(checkPointFile);
                outStream = new ObjectOutputStream(fileOutput);
                outStream.writeObject(this);
            }
            finally {
                block15: {
                    block14: {
                        if (null != outStream) {
                            try {
                                outStream.close();
                            }
                            catch (IOException e) {
                                if (!log.isWarnEnabled()) break block14;
                                log.warn("close failed.", e);
                            }
                        }
                    }
                    if (null != fileOutput) {
                        try {
                            fileOutput.close();
                        }
                        catch (IOException e) {
                            if (!log.isWarnEnabled()) break block15;
                            log.warn("close failed.", e);
                        }
                    }
                }
            }
        }

        public synchronized void update(int partIndex, PartEtag partETag, boolean completed, CRC64 partCRC64) {
            this.partEtags.add(partETag);
            this.uploadParts.get((int)partIndex).isCompleted = completed;
            if (partCRC64 != null) {
                this.partCRC64s.put(partETag.getPartNumber(), partCRC64);
            }
        }

        public boolean isValid(String uploadFile) throws IOException {
            if (this.md5 != this.hashCode()) {
                return false;
            }
            File upload = new File(uploadFile);
            if (!this.uploadFile.equals(uploadFile) || this.uploadFileStatus.size != upload.length() || this.uploadFileStatus.lastModified != upload.lastModified()) {
                return false;
            }
            if (this.uploadFileStatus.checkSum != null) {
                try {
                    return this.uploadFileStatus.checkSum.equals(ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(upload))));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ObsException("computeMD5Hash failed.", e);
                }
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.partEtags == null ? 0 : this.partEtags.hashCode());
            result = 31 * result + (this.partCRC64s == null ? 0 : this.partCRC64s.hashCode());
            result = 31 * result + (this.uploadFile == null ? 0 : this.uploadFile.hashCode());
            result = 31 * result + (this.uploadFileStatus == null ? 0 : this.uploadFileStatus.hashCode());
            result = 31 * result + (this.uploadID == null ? 0 : this.uploadID.hashCode());
            result = 31 * result + (this.uploadParts == null ? 0 : this.uploadParts.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof UploadCheckPoint) {
                UploadCheckPoint uploadCheckPoint = (UploadCheckPoint)obj;
                return uploadCheckPoint.hashCode() == obj.hashCode();
            }
            return false;
        }

        private void assign(UploadCheckPoint tmp) {
            this.md5 = tmp.md5;
            this.bucketName = tmp.bucketName;
            this.uploadFile = tmp.uploadFile;
            this.uploadFileStatus = tmp.uploadFileStatus;
            this.objectKey = tmp.objectKey;
            this.uploadID = tmp.uploadID;
            this.uploadParts = tmp.uploadParts;
            this.partEtags = tmp.partEtags;
            this.partCRC64s = tmp.partCRC64s;
        }
    }

    static class Mission
    implements Callable<PartResult> {
        private int id;
        private UploadCheckPoint uploadCheckPoint;
        private int partIndex;
        private UploadFileRequest uploadFileRequest;
        private AbstractClient obsClient;
        private ProgressManager progressManager;

        public Mission(int id, UploadCheckPoint uploadCheckPoint, int partIndex, UploadFileRequest uploadFileRequest, AbstractClient obsClient) {
            this.id = id;
            this.uploadCheckPoint = uploadCheckPoint;
            this.partIndex = partIndex;
            this.uploadFileRequest = uploadFileRequest;
            this.obsClient = obsClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public PartResult call() throws Exception {
            boolean uploadFileCanceled;
            PartResult tr = null;
            UploadPart uploadPart = this.uploadCheckPoint.uploadParts.get(this.partIndex);
            tr = new PartResult(this.partIndex + 1, uploadPart.offset, uploadPart.size);
            boolean bl = uploadFileCanceled = this.uploadFileRequest.getCancelHandler() != null && this.uploadFileRequest.getCancelHandler().isCancelled();
            if (uploadFileCanceled) {
                String errorInfo = String.format(Locale.ROOT, "Task %d:%s upload part %d canceled.", this.id, "upload" + this.id, this.partIndex + 1);
                log.warn(errorInfo);
                ObsException e = new ObsException(errorInfo);
                tr.setException(e);
                tr.setFailed(true);
                return tr;
            }
            if (!this.uploadCheckPoint.isAbort) {
                CRC64InputStream crc64InputStream = null;
                String failedInfoSuffix = String.format(Locale.ROOT, ", task %d:%s upload part %d failed.", this.id, "upload" + this.id, this.partIndex + 1);
                try {
                    UploadPartRequest uploadPartRequest = new UploadPartRequest();
                    uploadPartRequest.setBucketName(this.uploadFileRequest.getBucketName());
                    uploadPartRequest.setObjectKey(this.uploadFileRequest.getObjectKey());
                    uploadPartRequest.setUploadId(this.uploadCheckPoint.uploadID);
                    uploadPartRequest.setPartSize(uploadPart.size);
                    uploadPartRequest.setPartNumber(uploadPart.partNumber);
                    uploadPartRequest.setRequesterPays(this.uploadFileRequest.isRequesterPays());
                    uploadPartRequest.setUserHeaders(this.uploadFileRequest.getUserHeaders());
                    uploadPartRequest.setCancelHandler(this.uploadFileRequest.getCancelHandler());
                    uploadPartRequest.setNeedCalculateCRC64(this.uploadFileRequest.isNeedCalculateCRC64());
                    uploadPartRequest.setFile(new File(this.uploadFileRequest.getUploadFile()));
                    uploadPartRequest.setOffset(uploadPart.offset);
                    if (this.uploadFileRequest.isNeedStreamCalculateCRC64() && !this.uploadFileRequest.isNeedCalculateCRC64()) {
                        uploadPartRequest.setInput(new FileInputStream(this.uploadFileRequest.getUploadFile()));
                        long skipByte = uploadPartRequest.getInput().skip(uploadPart.offset);
                        crc64InputStream = new CRC64InputStream(uploadPartRequest.getInput());
                        uploadPartRequest.setInput(crc64InputStream);
                        log.info("CRC64InputStream Skip " + skipByte + " bytes; offset : " + uploadPart.offset);
                    }
                    if (this.progressManager != null) {
                        this.progressManager.setEndFlag(false);
                        uploadPartRequest.setProgressManager(this.progressManager);
                    }
                    UploadPartResult result = this.obsClient.uploadPart(uploadPartRequest);
                    this.tryCRC64StreamCheck(crc64InputStream, result, failedInfoSuffix);
                    PartEtag partEtag = new PartEtag(result.getEtag(), result.getPartNumber());
                    CRC64 partCRC64 = result.getClientCalculatedCRC64();
                    this.uploadCheckPoint.update(this.partIndex, partEtag, true, partCRC64);
                    tr.setFailed(false);
                    if (!this.uploadFileRequest.isEnableCheckpoint()) return tr;
                    this.uploadCheckPoint.record(this.uploadFileRequest.getCheckpointFile());
                    return tr;
                }
                catch (ObsException e) {
                    if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                        this.uploadCheckPoint.isAbort = true;
                    }
                    if (e.getResponseCode() == 403) {
                        this.uploadCheckPoint.isDeleteUploadRecordFile = false;
                    }
                    tr.setFailed(true);
                    tr.setException(e);
                    if (!log.isErrorEnabled()) return tr;
                    log.error(String.format(Locale.ROOT, "Task %d:%s upload part %d failed: ", this.id, "upload" + this.id, this.partIndex + 1), e);
                    return tr;
                }
                catch (Exception e) {
                    tr.setFailed(true);
                    tr.setException(e);
                    if (!log.isErrorEnabled()) return tr;
                    log.error(String.format(Locale.ROOT, "Task %d:%s upload part %d failed: ", this.id, "upload" + this.id, this.partIndex + 1), e);
                    return tr;
                }
                finally {
                    if (null != crc64InputStream) {
                        crc64InputStream.close();
                    }
                }
            } else {
                tr.setFailed(true);
            }
            return tr;
        }

        private String tryGetRequestID(UploadPartResult uploadPartResult) {
            if (uploadPartResult == null) {
                return "";
            }
            Map<String, Object> responseHeaders = uploadPartResult.getResponseHeaders();
            if (responseHeaders == null) {
                return "";
            }
            return (String)responseHeaders.get("request-id");
        }

        public void tryCRC64StreamCheck(CRC64InputStream crc64InputStream, UploadPartResult result, String failedInfoSuffix) {
            if (this.uploadFileRequest.isNeedStreamCalculateCRC64() && !this.uploadFileRequest.isNeedCalculateCRC64()) {
                String errorInfo = null;
                if (crc64InputStream != null) {
                    result.setClientCalculatedCRC64(crc64InputStream.getCrc64());
                    String sdkCalculatedCRC64 = result.getClientCalculatedCRC64().toString();
                    String serverCRC64 = (String)result.getResponseHeaders().get("checksum-crc64ecma");
                    if (serverCRC64 == null) {
                        errorInfo = "UploadPartResult.getResponseHeaders() doesn't contains checksum-crc64ecma, crc64 check failed" + failedInfoSuffix + " server requestID is " + this.tryGetRequestID(result);
                    } else if (!sdkCalculatedCRC64.equals(serverCRC64)) {
                        errorInfo = "UploadPart CRC64 mismatch! sdk calculated downloadFile CRC64 is " + sdkCalculatedCRC64 + " server returned CRC64 is " + serverCRC64 + " server requestID is " + this.tryGetRequestID(result) + failedInfoSuffix;
                    }
                } else {
                    errorInfo = "Crc64InputStream is null, crc64 not set server requestID is " + this.tryGetRequestID(result) + failedInfoSuffix;
                }
                if (errorInfo != null) {
                    log.error(errorInfo);
                    ObsException obsException = new ObsException(errorInfo);
                    obsException.setErrorCode("InvalidCRC64");
                    throw obsException;
                }
            }
        }

        public void setProgressManager(ProgressManager progressManager) {
            this.progressManager = progressManager;
        }
    }
}

