/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.BaseObjectRequest;
import com.obs.services.model.CacheOptionEnum;
import com.obs.services.model.ProgressListener;
import java.util.Date;

public class DownloadFileRequest
extends BaseObjectRequest {
    private String downloadFile;
    private long partSize = 0x900000L;
    private int taskNum = 1;
    private String checkpointFile;
    private boolean enableCheckpoint;
    private Date ifModifiedSince;
    private Date ifUnmodifiedSince;
    private String ifMatchTag;
    private String ifNoneMatchTag;
    private String versionId;
    private ProgressListener progressListener;
    private long progressInterval = 102400L;
    private CacheOptionEnum cacheOption;
    private long ttl;
    private boolean needCalculateCRC64 = false;

    public DownloadFileRequest(String bucketName, String objectKey) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.downloadFile = objectKey;
    }

    public DownloadFileRequest(String bucketName, String objectKey, String downloadFile) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.downloadFile = downloadFile;
    }

    public DownloadFileRequest(String bucketName, String objectKey, String downloadFile, long partSize) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.downloadFile = downloadFile;
        this.partSize = partSize;
    }

    public DownloadFileRequest(String bucketName, String objectKey, String downloadFile, long partSize, int taskNum) {
        this(bucketName, objectKey, downloadFile, partSize, taskNum, false);
    }

    public DownloadFileRequest(String bucketName, String objectKey, String downloadFile, long partSize, int taskNum, boolean enableCheckpoint) {
        this(bucketName, objectKey, downloadFile, partSize, taskNum, enableCheckpoint, null);
    }

    public DownloadFileRequest(String bucketName, String objectKey, String downloadFile, long partSize, int taskNum, boolean enableCheckpoint, String checkpointFile) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.partSize = partSize;
        this.taskNum = taskNum;
        this.downloadFile = downloadFile;
        this.enableCheckpoint = enableCheckpoint;
        this.checkpointFile = checkpointFile;
    }

    public DownloadFileRequest(String bucketName, String objectKey, String downloadFile, long partSize, int taskNum, boolean enableCheckpoint, String checkpointFile, String versionId) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.partSize = partSize;
        this.taskNum = taskNum;
        this.downloadFile = downloadFile;
        this.enableCheckpoint = enableCheckpoint;
        this.checkpointFile = checkpointFile;
        this.versionId = versionId;
    }

    public String getDownloadFile() {
        return this.downloadFile;
    }

    public void setDownloadFile(String downloadFile) {
        this.downloadFile = downloadFile;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(int taskNum) {
        this.taskNum = taskNum < 1 ? 1 : Math.min(taskNum, 1000);
    }

    public boolean isEnableCheckpoint() {
        return this.enableCheckpoint;
    }

    public void setEnableCheckpoint(boolean enableCheckpoint) {
        this.enableCheckpoint = enableCheckpoint;
    }

    public String getCheckpointFile() {
        return this.checkpointFile;
    }

    public void setCheckpointFile(String checkpointFile) {
        this.checkpointFile = checkpointFile;
    }

    public String getTempDownloadFile() {
        return this.downloadFile + ".tmp";
    }

    public Date getIfModifiedSince() {
        return ServiceUtils.cloneDateIgnoreNull(this.ifModifiedSince);
    }

    public void setIfModifiedSince(Date ifModifiedSince) {
        this.ifModifiedSince = ServiceUtils.cloneDateIgnoreNull(ifModifiedSince);
    }

    public Date getIfUnmodifiedSince() {
        return ServiceUtils.cloneDateIgnoreNull(this.ifUnmodifiedSince);
    }

    public void setIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ServiceUtils.cloneDateIgnoreNull(ifUnmodifiedSince);
    }

    public String getIfMatchTag() {
        return this.ifMatchTag;
    }

    public void setIfMatchTag(String ifMatchTag) {
        this.ifMatchTag = ifMatchTag;
    }

    public String getIfNoneMatchTag() {
        return this.ifNoneMatchTag;
    }

    public void setIfNoneMatchTag(String ifNoneMatchTag) {
        this.ifNoneMatchTag = ifNoneMatchTag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public long getProgressInterval() {
        return this.progressInterval;
    }

    public void setProgressInterval(long progressInterval) {
        this.progressInterval = progressInterval;
    }

    public CacheOptionEnum getCacheOption() {
        return this.cacheOption;
    }

    public void setCacheOption(CacheOptionEnum cacheOption) {
        this.cacheOption = cacheOption;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        if (ttl < 0L || ttl > 259200L) {
            ttl = 86400L;
        }
        this.ttl = ttl;
    }

    public boolean isNeedCalculateCRC64() {
        return this.needCalculateCRC64;
    }

    public void setNeedCalculateCRC64(boolean needCalculateCRC64) {
        this.needCalculateCRC64 = needCalculateCRC64;
    }

    @Override
    public String toString() {
        return "DownloadFileRequest [bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ", downloadFile=" + this.downloadFile + ", partSize=" + this.partSize + ", taskNum=" + this.taskNum + ", checkpointFile=" + this.checkpointFile + ", enableCheckpoint=" + this.enableCheckpoint + ", ifModifiedSince=" + this.ifModifiedSince + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", ifMatchTag=" + this.ifMatchTag + ", ifNoneMatchTag=" + this.ifNoneMatchTag + ", versionId=" + this.versionId + ", isEncodeHeaders=" + this.encodeHeaders + "]";
    }
}

