/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.xml;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.security.AccessController;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OBSXMLBuilder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";
    private static String xmlDocumentBuilderFactoryClass = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static String xmlTransformerFactoryClass = "";
    private static final ILogger log = LoggerBuilder.getLogger(OBSXMLBuilder.class);
    private Document xmlDocument;
    private Node xmlNode;

    public static void setXmlDocumentBuilderFactoryClass(String className) {
        if (null != className && !className.trim().equals("")) {
            xmlDocumentBuilderFactoryClass = className;
        }
    }

    public static void setXmlTransformerFactoryClass(String className) {
        if (null != className && !className.trim().equals("")) {
            xmlTransformerFactoryClass = className;
        }
    }

    protected OBSXMLBuilder(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xmlNode = xmlDocument.getDocumentElement();
    }

    protected OBSXMLBuilder(Node myNode, Node parentNode) {
        this.xmlNode = myNode;
        this.xmlDocument = myNode instanceof Document ? (Document)myNode : myNode.getOwnerDocument();
        if (parentNode != null) {
            parentNode.appendChild(myNode);
        }
    }

    private static DocumentBuilderFactory findDocumentBuilderFactory() {
        if (xmlDocumentBuilderFactoryClass != null && xmlDocumentBuilderFactoryClass.startsWith(DEFAULT_PACKAGE)) {
            return DocumentBuilderFactory.newInstance();
        }
        return OBSXMLBuilder.newInstance(DocumentBuilderFactory.class, xmlDocumentBuilderFactoryClass, null, true, false);
    }

    private static TransformerFactory findTransformerFactory() {
        if (xmlTransformerFactoryClass == null || xmlTransformerFactoryClass.equals("")) {
            return TransformerFactory.newInstance();
        }
        return TransformerFactory.newInstance(xmlTransformerFactoryClass, null);
    }

    protected static Document createDocumentImpl(String name, String namespaceURI, boolean isNamespaceAware) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory factory = OBSXMLBuilder.findDocumentBuilderFactory();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Throwable e) {
            log.debug("setFeature not supported, detail:", e);
        }
        factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = namespaceURI != null && namespaceURI.length() > 0 ? document.createElementNS(namespaceURI, name) : document.createElement(name);
        document.appendChild(rootElement);
        return document;
    }

    protected static Document parseDocumentImpl(InputSource inputSource, boolean isNamespaceAware) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = OBSXMLBuilder.findDocumentBuilderFactory();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inputSource);
        return document;
    }

    private static ClassLoader getContextClassLoader() throws SecurityException {
        return (ClassLoader)AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }

    private static Class<?> getProviderClass(String className, ClassLoader cl, boolean doFallback, boolean useBSClsLoader) throws ClassNotFoundException {
        try {
            if (cl == null) {
                if (useBSClsLoader) {
                    cl = OBSXMLBuilder.class.getClassLoader();
                } else {
                    cl = OBSXMLBuilder.getContextClassLoader();
                    if (cl == null) {
                        throw new ClassNotFoundException();
                    }
                }
            }
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e1) {
            if (doFallback) {
                return Class.forName(className, false, OBSXMLBuilder.class.getClassLoader());
            }
            throw e1;
        }
    }

    private static <T> T newInstance(Class<T> type, String className, ClassLoader cl, boolean doFallback, boolean useBSClsLoader) throws FactoryConfigurationError {
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            cl = null;
            useBSClsLoader = true;
        }
        try {
            Class<?> providerClass = OBSXMLBuilder.getProviderClass(className, cl, doFallback, useBSClsLoader);
            if (!type.isAssignableFrom(providerClass)) {
                throw new ClassCastException(className + " cannot be cast to " + type.getName());
            }
            Object instance = providerClass.newInstance();
            return type.cast(instance);
        }
        catch (ClassNotFoundException x) {
            throw new FactoryConfigurationError(x, "Provider " + className + " not found");
        }
        catch (Exception x) {
            throw new FactoryConfigurationError(x, "Provider " + className + " could not be instantiated: " + x);
        }
    }

    public static OBSXMLBuilder create(String name) throws ParserConfigurationException, FactoryConfigurationError {
        return new OBSXMLBuilder(OBSXMLBuilder.createDocumentImpl(name, null, true));
    }

    public static OBSXMLBuilder parse(InputSource inputSource, boolean isNamespaceAware) throws ParserConfigurationException, SAXException, IOException {
        return new OBSXMLBuilder(OBSXMLBuilder.parseDocumentImpl(inputSource, isNamespaceAware));
    }

    public static OBSXMLBuilder parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        return OBSXMLBuilder.parse(inputSource, true);
    }

    public OBSXMLBuilder importXMLBuilder(OBSXMLBuilder builder) {
        Node importedNode = this.getDocument().importNode(builder.getDocument().getDocumentElement(), true);
        this.xmlNode.appendChild(importedNode);
        return this;
    }

    public OBSXMLBuilder element(String name) {
        String namespaceURI = this.lookupNamespaceURI(name);
        return this.element(name, namespaceURI);
    }

    public OBSXMLBuilder elem(String name) {
        return this.element(name);
    }

    public OBSXMLBuilder e(String name) {
        return this.element(name);
    }

    public OBSXMLBuilder element(String name, String namespaceURI) {
        Element elem = this.elementImpl(name, namespaceURI);
        return new OBSXMLBuilder(elem, this.getElement());
    }

    public Element elementImpl(String name, String namespaceURI) {
        return namespaceURI == null ? this.getDocument().createElement(name) : this.getDocument().createElementNS(namespaceURI, name);
    }

    public OBSXMLBuilder attribute(String name, String value) {
        this.attributeImpl(name, value);
        return this;
    }

    public void textImpl(String value, boolean replaceText) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal null text value");
        }
        if (replaceText) {
            this.xmlNode.setTextContent(value);
        } else {
            this.xmlNode.appendChild(this.getDocument().createTextNode(value));
        }
    }

    public void attributeImpl(String name, String value) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + this.xmlNode);
        }
        ((Element)this.xmlNode).setAttribute(name, value);
    }

    public OBSXMLBuilder attr(String name, String value) {
        return this.attribute(name, value);
    }

    public OBSXMLBuilder text(String value, boolean replaceText) {
        this.textImpl(value, replaceText);
        return this;
    }

    public OBSXMLBuilder text(String value) {
        return this.text(value, false);
    }

    public OBSXMLBuilder t(String value) {
        return this.text(value);
    }

    protected Node upImpl(int steps) {
        Node currNode = this.xmlNode;
        for (int stepCount = 0; currNode.getParentNode() != null && stepCount < steps; ++stepCount) {
            currNode = currNode.getParentNode();
        }
        return currNode;
    }

    public OBSXMLBuilder up(int steps) {
        Node currNode = this.upImpl(steps);
        if (currNode instanceof Document) {
            return new OBSXMLBuilder((Document)currNode);
        }
        return new OBSXMLBuilder(currNode, null);
    }

    public OBSXMLBuilder up() {
        return this.up(1);
    }

    public Element getElement() {
        return this.xmlNode instanceof Element ? (Element)this.xmlNode : null;
    }

    protected String lookupNamespaceURI(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        return this.xmlNode.lookupNamespaceURI(prefix);
    }

    protected String getPrefixFromQualifiedName(String qualifiedName) {
        int colonPos = qualifiedName.indexOf(58);
        return colonPos > 0 ? qualifiedName.substring(0, colonPos) : null;
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public String asString() throws TransformerException {
        TransformerFactory tf = OBSXMLBuilder.findTransformerFactory();
        try {
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (Throwable e) {
            log.debug("setAttribute not supported, detail:", e);
        }
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(this.getDocument()), new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("|\r", "");
    }

    public int hashCode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

