/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.exception;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObsException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String xmlMessage = null;
    private String errorCode = null;
    private String errorMessage = null;
    private String errorRequestId = null;
    private String errorHostId = null;
    private Map<String, String> responseHeaders = null;
    private int responseCode = -1;
    private String responseStatus = null;
    private String errorIndicator = null;

    public ObsException(String message) {
        this(message, null, null);
    }

    public ObsException(String message, Throwable e) {
        this(message, null, e);
    }

    public ObsException(String message, String xmlMessage) {
        this(message, xmlMessage, null);
    }

    public ObsException(String message, String xmlMessage, Throwable cause) {
        super(message, cause);
        if (xmlMessage != null) {
            this.parseXmlMessage(xmlMessage);
        }
    }

    @Override
    public String toString() {
        StringBuilder myString = new StringBuilder(super.toString());
        if (this.responseCode != -1) {
            myString.append(" -- ResponseCode: ").append(this.responseCode).append(", ResponseStatus: ").append(this.responseStatus);
        }
        if (this.isParsedFromXmlMessage()) {
            myString.append(", XML Error Message: ").append(this.xmlMessage);
        } else if (this.errorRequestId != null) {
            myString.append(", RequestId: ").append(this.errorRequestId).append(", HostId: ").append(this.errorHostId);
        }
        Map<String, String> headers = this.getResponseHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (!header.getKey().toLowerCase(Locale.ROOT).contains("error")) continue;
                myString.append(", ErrorHeaderKey: ").append(header.getKey()).append(", ErrorHeaderValue: ").append(header.getValue());
            }
        }
        return myString.toString();
    }

    private boolean isParsedFromXmlMessage() {
        return this.xmlMessage != null;
    }

    private String findXmlElementText(String xmlMsg, String elementName) {
        Pattern pattern = Pattern.compile(".*<" + elementName + ">(.*)</" + elementName + ">.*");
        Matcher matcher = pattern.matcher(xmlMsg);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private void parseXmlMessage(String xmlMsg) {
        this.xmlMessage = xmlMsg = xmlMsg.replaceAll("\n", "");
        this.errorCode = this.findXmlElementText(xmlMsg, "Code");
        this.errorMessage = this.findXmlElementText(xmlMsg, "Message");
        this.errorRequestId = this.findXmlElementText(xmlMsg, "RequestId");
        this.errorHostId = this.findXmlElementText(xmlMsg, "HostId");
    }

    public String getXmlMessage() {
        return this.xmlMessage;
    }

    public void setXmlMessage(String xmlMessage) {
        this.xmlMessage = xmlMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorRequestId() {
        return this.errorRequestId;
    }

    public void setErrorRequestId(String errorRequestId) {
        this.errorRequestId = errorRequestId;
    }

    public String getErrorHostId() {
        return this.errorHostId;
    }

    public void setErrorHostId(String errorHostId) {
        this.errorHostId = errorHostId;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(String responseStatus) {
        this.responseStatus = responseStatus;
    }

    public String getErrorIndicator() {
        return this.errorIndicator;
    }

    public void setErrorIndicator(String errorIndicator) {
        this.errorIndicator = errorIndicator;
    }
}

