/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.model.ISecurityKey;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RefreshAkSkStsTokenProvider
implements IObsCredentialsProvider {
    private static final ILogger log = LoggerBuilder.getLogger(RefreshAkSkStsTokenProvider.class);
    private ISecurityKey securityKey;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final long REFRESH_INTERVAL_MINUTES = 10L;
    private final OkHttpClient httpClient;
    private String iamDomain;
    private String iamUser;
    private String iamPassword;
    private String iamEndpoint;
    private boolean refreshTaskStarted = false;
    private final Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();

    public RefreshAkSkStsTokenProvider(String iamDomain, String iamUser, String iamPassword, String iamEndpoint, OkHttpClient httpClient) {
        this.iamDomain = iamDomain;
        this.iamUser = iamUser;
        this.iamPassword = iamPassword;
        this.iamEndpoint = iamEndpoint;
        this.httpClient = httpClient != null ? httpClient : new OkHttpClient();
    }

    public void startTokenRefreshTask() {
        if (!this.refreshTaskStarted) {
            this.scheduler.scheduleAtFixedRate(this::refreshSecurityKey, 0L, 10L, TimeUnit.MINUTES);
            this.refreshTaskStarted = true;
        }
    }

    @Override
    public void setSecurityKey(ISecurityKey securityKey) {
        this.securityKey = securityKey;
    }

    @Override
    public ISecurityKey getSecurityKey() {
        this.refreshSecurityKey();
        return this.securityKey;
    }

    private void refreshSecurityKey() {
        try {
            ISecurityKey newSecurityKey = this.fetchAkSkStsToken();
            this.setSecurityKey(newSecurityKey);
            log.debug("Security key refreshed successfully.");
        }
        catch (Exception e) {
            log.error("Failed to refresh security key: " + e.getMessage(), e);
        }
    }

    private ISecurityKey fetchAkSkStsToken() throws IOException {
        String subjectToken = this.getSubjectToken();
        if (subjectToken == null) {
            log.error("Failed to fetch subject token.");
            throw new IOException("Subject token is null.");
        }
        return this.getSecurityToken(subjectToken);
    }

    private String getSubjectToken() throws IOException {
        String jsonPayload = "{ \"auth\": { \"identity\": { \"methods\": [\"password\"], \"password\": { \"user\": { \"domain\": { \"name\": \"" + this.iamDomain + "\" }, \"name\": \"" + this.iamUser + "\", \"password\": \"" + this.iamPassword + "\" } } }, \"scope\": { \"domain\": { \"name\": \"" + this.iamDomain + "\" } } } }";
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(this.iamEndpoint + "/v3/auth/tokens").post(body).build();
        Call call = this.httpClient.newCall(request);
        if (call == null) {
            throw new IllegalStateException("OkHttpClient failed to create a new Call. Ensure httpClient is properly initialized with " + this.iamEndpoint + "/v3/auth/tokens");
        }
        try (Response response = call.execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = response.header("X-Subject-Token");
            return string;
        }
    }

    private ISecurityKey getSecurityToken(String subjectToken) throws IOException {
        String jsonPayload = "{ \"auth\": { \"identity\": { \"methods\": [\"token\"], \"token\": { \"id\": \"" + subjectToken + "\", \"duration_seconds\": 900 } } } }";
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(this.iamEndpoint + "/v3.0/OS-CREDENTIAL/securitytokens").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new IOException("Response body is null");
            }
            String responseBodyString = responseBody.string();
            String newAccessKey = this.extractJsonField(responseBodyString, "access");
            String newSecretKey = this.extractJsonField(responseBodyString, "secret");
            String newSecurityToken = this.extractJsonField(responseBodyString, "securitytoken");
            if (newAccessKey == null || newSecretKey == null || newSecurityToken == null) {
                throw new IllegalStateException("Failed to extract security keys.");
            }
            BasicSecurityKey basicSecurityKey = new BasicSecurityKey(newAccessKey, newSecretKey, newSecurityToken);
            return basicSecurityKey;
        }
    }

    private String extractJsonField(String json, String field) {
        Pattern pattern = this.patternCache.computeIfAbsent(field, key -> Pattern.compile("\"" + field + "\":\"([^\"]+)\""));
        Matcher matcher = pattern.matcher(json);
        return matcher.find() ? matcher.group(1) : null;
    }
}

