/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.functiongraph.v2.region.FunctionGraphTenantRegion;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClientBuilder<T>
extends ClientBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(CustomClientBuilder.class);

    public CustomClientBuilder(Function<HcClient, T> creator) {
        super(creator);
    }

    public CustomClientBuilder(Function<HcClient, T> creator, String credentialType) {
        super(creator, credentialType);
    }

    public T build() {
        this.processRegion();
        return (T)super.build();
    }

    private void processRegion() {
        Region region = this.getRegion();
        if (Objects.nonNull(region) && region != FunctionGraphTenantRegion.valueOf(region.getId())) {
            FunctionGraphTenantRegion.processRegion(region);
        }
    }
}

