/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.functiongraph.v2.model.OBSTriggerConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Trigger {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_name")
    private String triggerName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_type")
    private TriggerTypeEnum triggerType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_config")
    private OBSTriggerConfig triggerConfig;

    public Trigger withTriggerName(String triggerName) {
        this.triggerName = triggerName;
        return this;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public Trigger withTriggerType(TriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public TriggerTypeEnum getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
    }

    public Trigger withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Trigger withTriggerConfig(OBSTriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
        return this;
    }

    public Trigger withTriggerConfig(Consumer<OBSTriggerConfig> triggerConfigSetter) {
        if (this.triggerConfig == null) {
            this.triggerConfig = new OBSTriggerConfig();
            triggerConfigSetter.accept(this.triggerConfig);
        }
        return this;
    }

    public OBSTriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    public void setTriggerConfig(OBSTriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Trigger that = (Trigger)obj;
        return Objects.equals(this.triggerName, that.triggerName) && Objects.equals(this.triggerType, that.triggerType) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.triggerConfig, that.triggerConfig);
    }

    public int hashCode() {
        return Objects.hash(this.triggerName, this.triggerType, this.enabled, this.triggerConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trigger {\n");
        sb.append("    triggerName: ").append(this.toIndentedString(this.triggerName)).append("\n");
        sb.append("    triggerType: ").append(this.toIndentedString(this.triggerType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    triggerConfig: ").append(this.toIndentedString(this.triggerConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TriggerTypeEnum {
        public static final TriggerTypeEnum FLOWTIMER = new TriggerTypeEnum("FLOWTIMER");
        public static final TriggerTypeEnum SMN = new TriggerTypeEnum("SMN");
        public static final TriggerTypeEnum APIG = new TriggerTypeEnum("APIG");
        public static final TriggerTypeEnum APIG_DE = new TriggerTypeEnum("APIG_DE");
        public static final TriggerTypeEnum OBS = new TriggerTypeEnum("OBS");
        private static final Map<String, TriggerTypeEnum> STATIC_FIELDS = TriggerTypeEnum.createStaticFields();
        private String value;

        private static Map<String, TriggerTypeEnum> createStaticFields() {
            HashMap<String, TriggerTypeEnum> map = new HashMap<String, TriggerTypeEnum>();
            map.put("FLOWTIMER", FLOWTIMER);
            map.put("SMN", SMN);
            map.put("APIG", APIG);
            map.put("APIG_DE", APIG_DE);
            map.put("OBS", OBS);
            return Collections.unmodifiableMap(map);
        }

        TriggerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TriggerTypeEnum(value));
        }

        public static TriggerTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TriggerTypeEnum) {
                return this.value.equals(((TriggerTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

