/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ServiceStatement {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Action")
    private List<String> action = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Effect")
    private EffectEnum effect;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Condition")
    private Map<String, Map<String, List<String>>> condition = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Resource")
    private List<String> resource = null;

    public ServiceStatement withAction(List<String> action) {
        this.action = action;
        return this;
    }

    public ServiceStatement addActionItem(String actionItem) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        this.action.add(actionItem);
        return this;
    }

    public ServiceStatement withAction(Consumer<List<String>> actionSetter) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        actionSetter.accept(this.action);
        return this;
    }

    public List<String> getAction() {
        return this.action;
    }

    public void setAction(List<String> action) {
        this.action = action;
    }

    public ServiceStatement withEffect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public ServiceStatement withCondition(Map<String, Map<String, List<String>>> condition) {
        this.condition = condition;
        return this;
    }

    public ServiceStatement putConditionItem(String key, Map<String, List<String>> conditionItem) {
        if (this.condition == null) {
            this.condition = new HashMap<String, Map<String, List<String>>>();
        }
        this.condition.put(key, conditionItem);
        return this;
    }

    public ServiceStatement withCondition(Consumer<Map<String, Map<String, List<String>>>> conditionSetter) {
        if (this.condition == null) {
            this.condition = new HashMap<String, Map<String, List<String>>>();
        }
        conditionSetter.accept(this.condition);
        return this;
    }

    public Map<String, Map<String, List<String>>> getCondition() {
        return this.condition;
    }

    public void setCondition(Map<String, Map<String, List<String>>> condition) {
        this.condition = condition;
    }

    public ServiceStatement withResource(List<String> resource) {
        this.resource = resource;
        return this;
    }

    public ServiceStatement addResourceItem(String resourceItem) {
        if (this.resource == null) {
            this.resource = new ArrayList<String>();
        }
        this.resource.add(resourceItem);
        return this;
    }

    public ServiceStatement withResource(Consumer<List<String>> resourceSetter) {
        if (this.resource == null) {
            this.resource = new ArrayList<String>();
        }
        resourceSetter.accept(this.resource);
        return this;
    }

    public List<String> getResource() {
        return this.resource;
    }

    public void setResource(List<String> resource) {
        this.resource = resource;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceStatement that = (ServiceStatement)obj;
        return Objects.equals(this.action, that.action) && Objects.equals(this.effect, that.effect) && Objects.equals(this.condition, that.condition) && Objects.equals(this.resource, that.resource);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.effect, this.condition, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceStatement {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EffectEnum {
        public static final EffectEnum ALLOW = new EffectEnum("Allow");
        public static final EffectEnum DENY = new EffectEnum("Deny");
        private static final Map<String, EffectEnum> STATIC_FIELDS = EffectEnum.createStaticFields();
        private String value;

        private static Map<String, EffectEnum> createStaticFields() {
            HashMap<String, EffectEnum> map = new HashMap<String, EffectEnum>();
            map.put("Allow", ALLOW);
            map.put("Deny", DENY);
            return Collections.unmodifiableMap(map);
        }

        EffectEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EffectEnum(value));
        }

        public static EffectEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EffectEnum) {
                return this.value.equals(((EffectEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

