package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;
import java.util.function.Consumer;

/**
 * 
 */
public class UpdateLoginProjectReq {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "login_protect")

    private UpdateLoginProject loginProtect;

    public UpdateLoginProjectReq withLoginProtect(UpdateLoginProject loginProtect) {
        this.loginProtect = loginProtect;
        return this;
    }

    public UpdateLoginProjectReq withLoginProtect(Consumer<UpdateLoginProject> loginProtectSetter) {
        if (this.loginProtect == null) {
            this.loginProtect = new UpdateLoginProject();
            loginProtectSetter.accept(this.loginProtect);
        }

        return this;
    }

    /**
     * Get loginProtect
     * @return loginProtect
     */
    public UpdateLoginProject getLoginProtect() {
        return loginProtect;
    }

    public void setLoginProtect(UpdateLoginProject loginProtect) {
        this.loginProtect = loginProtect;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || getClass() != obj.getClass()) {
            return false;
        }
        UpdateLoginProjectReq that = (UpdateLoginProjectReq) obj;
        return Objects.equals(this.loginProtect, that.loginProtect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(loginProtect);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateLoginProjectReq {\n");
        sb.append("    loginProtect: ").append(toIndentedString(loginProtect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
