/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.smn.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.smn.v2.model.HttpDetectRequestBodyExtension;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class HttpDetectRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="protocol")
    private ProtocolEnum protocol;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoint")
    private String endpoint;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="extension")
    private HttpDetectRequestBodyExtension extension;

    public HttpDetectRequestBody withProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public HttpDetectRequestBody withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public HttpDetectRequestBody withExtension(HttpDetectRequestBodyExtension extension) {
        this.extension = extension;
        return this;
    }

    public HttpDetectRequestBody withExtension(Consumer<HttpDetectRequestBodyExtension> extensionSetter) {
        if (this.extension == null) {
            this.extension = new HttpDetectRequestBodyExtension();
            extensionSetter.accept(this.extension);
        }
        return this;
    }

    public HttpDetectRequestBodyExtension getExtension() {
        return this.extension;
    }

    public void setExtension(HttpDetectRequestBodyExtension extension) {
        this.extension = extension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpDetectRequestBody that = (HttpDetectRequestBody)obj;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.endpoint, this.extension);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HttpDetectRequestBody {\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ProtocolEnum {
        public static final ProtocolEnum HTTP = new ProtocolEnum("http");
        public static final ProtocolEnum HTTPS = new ProtocolEnum("https");
        private static final Map<String, ProtocolEnum> STATIC_FIELDS = ProtocolEnum.createStaticFields();
        private String value;

        private static Map<String, ProtocolEnum> createStaticFields() {
            HashMap<String, ProtocolEnum> map = new HashMap<String, ProtocolEnum>();
            map.put("http", HTTP);
            map.put("https", HTTPS);
            return Collections.unmodifiableMap(map);
        }

        ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ProtocolEnum(value));
        }

        public static ProtocolEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProtocolEnum) {
                return this.value.equals(((ProtocolEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

