/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.smn.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MessageAttribute {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value")
    private Object value;

    public MessageAttribute withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageAttribute withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MessageAttribute withValue(Object value) {
        this.value = value;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageAttribute that = (MessageAttribute)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageAttribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum STRING = new TypeEnum("STRING");
        public static final TypeEnum STRING_ARRAY = new TypeEnum("STRING_ARRAY");
        public static final TypeEnum PROTOCOL = new TypeEnum("PROTOCOL");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("STRING", STRING);
            map.put("STRING_ARRAY", STRING_ARRAY);
            map.put("PROTOCOL", PROTOCOL);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

