/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.util;

import com.hubspot.horizon.shaded.com.ning.http.client.ProxyServer;
import com.hubspot.horizon.shaded.com.ning.http.client.Realm;
import com.hubspot.horizon.shaded.com.ning.http.client.Request;
import com.hubspot.horizon.shaded.com.ning.http.client.ntlm.NTLMEngine;
import com.hubspot.horizon.shaded.com.ning.http.client.spnego.SpnegoEngine;
import com.hubspot.horizon.shaded.com.ning.http.client.uri.Uri;
import com.hubspot.horizon.shaded.com.ning.http.util.AsyncHttpProviderUtils;
import com.hubspot.horizon.shaded.com.ning.http.util.Base64;
import com.hubspot.horizon.shaded.com.ning.http.util.MiscUtils;
import com.hubspot.horizon.shaded.com.ning.http.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class AuthenticatorUtils {
    private static final String PROXY_AUTH_HEADER = "Proxy-Authorization";

    public static String perConnectionAuthorizationHeader(Request request, Uri uri, ProxyServer proxyServer, Realm realm) throws IOException {
        String authorizationHeader = null;
        if (realm != null && realm.getUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NTLMEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : uri.getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.INSTANCE.generateToken(host);
                        break;
                    }
                    catch (Throwable e) {
                        throw new IOException(e);
                    }
                }
            }
        }
        return authorizationHeader;
    }

    public static String perRequestAuthorizationHeader(Request request, Uri uri, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.getUsePreemptiveAuth() && !realm.isTargetProxy()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: 
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }

    public static String perConnectionProxyAuthorizationHeader(Request request, ProxyServer proxyServer, boolean connect) throws IOException {
        Object auth;
        String proxyAuthorization = null;
        if (connect) {
            Object auth2 = request.getHeaders().get(PROXY_AUTH_HEADER);
            String ntlmHeader = AsyncHttpProviderUtils.getNTLM((List<String>)auth2);
            if (ntlmHeader != null) {
                proxyAuthorization = ntlmHeader;
            }
        } else if (proxyServer != null && proxyServer.getPrincipal() != null && MiscUtils.isNonEmpty(proxyServer.getNtlmDomain()) && AsyncHttpProviderUtils.getNTLM((List<String>)(auth = request.getHeaders().get(PROXY_AUTH_HEADER))) == null) {
            String msg = NTLMEngine.INSTANCE.generateType1Msg();
            proxyAuthorization = "NTLM " + msg;
        }
        return proxyAuthorization;
    }

    public static String perRequestProxyAuthorizationHeader(Request request, Realm realm, ProxyServer proxyServer, boolean connect) {
        String proxyAuthorization = null;
        if (!connect && proxyServer != null && proxyServer.getPrincipal() != null && proxyServer.getScheme() == Realm.AuthScheme.BASIC) {
            proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyServer);
        } else if (realm != null && realm.getUsePreemptiveAuth() && realm.isTargetProxy()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: 
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return proxyAuthorization;
    }

    public static String computeBasicAuthentication(Realm realm) {
        return AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset());
    }

    public static String computeBasicAuthentication(ProxyServer proxyServer) {
        return AuthenticatorUtils.computeBasicAuthentication(proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getCharset());
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.encode(s.getBytes(charset));
    }

    public static String computeRealmURI(Realm realm) {
        return AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    public static String computeDigestAuthentication(Realm realm) {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", AuthenticatorUtils.computeRealmURI(realm), true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static StringBuilder append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        return builder.append(", ");
    }
}

