/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.util;

import java.util.BitSet;

public final class UTF8UrlEncoder {
    public static final BitSet RFC3986_UNRESERVED_CHARS;
    public static final BitSet RFC3986_RESERVED_CHARS;
    public static final BitSet RFC3986_SUBDELIM_CHARS;
    public static final BitSet RFC3986_PCHARS;
    public static final BitSet BUILT_PATH_UNTOUCHED_CHARS;
    public static final BitSet BUILT_QUERY_UNTOUCHED_CHARS;
    public static final BitSet FORM_URL_ENCODED_SAFE_CHARS;
    private static final char[] HEX;

    private UTF8UrlEncoder() {
    }

    public static String encodePath(String input) {
        StringBuilder sb = new StringBuilder(input.length() + 6);
        UTF8UrlEncoder.appendEncoded(sb, input, BUILT_PATH_UNTOUCHED_CHARS, false);
        return sb.toString();
    }

    public static StringBuilder encodeAndAppendQuery(StringBuilder sb, String query) {
        return UTF8UrlEncoder.appendEncoded(sb, query, BUILT_QUERY_UNTOUCHED_CHARS, false);
    }

    public static String encodeQueryElement(String input) {
        StringBuilder sb = new StringBuilder(input.length() + 6);
        UTF8UrlEncoder.encodeAndAppendQueryElement(sb, input);
        return sb.toString();
    }

    public static StringBuilder encodeAndAppendQueryElement(StringBuilder sb, CharSequence input) {
        return UTF8UrlEncoder.appendEncoded(sb, input, RFC3986_UNRESERVED_CHARS, false);
    }

    public static StringBuilder encodeAndAppendFormElement(StringBuilder sb, CharSequence input) {
        return UTF8UrlEncoder.appendEncoded(sb, input, FORM_URL_ENCODED_SAFE_CHARS, true);
    }

    private static StringBuilder appendEncoded(StringBuilder sb, CharSequence input, BitSet dontNeedEncoding, boolean encodeSpaceAsPlus) {
        int c;
        for (int i = 0; i < input.length(); i += Character.charCount(c)) {
            c = Character.codePointAt(input, i);
            if (c <= 127) {
                if (dontNeedEncoding.get(c)) {
                    sb.append((char)c);
                    continue;
                }
                UTF8UrlEncoder.appendSingleByteEncoded(sb, c, encodeSpaceAsPlus);
                continue;
            }
            UTF8UrlEncoder.appendMultiByteEncoded(sb, c);
        }
        return sb;
    }

    private static final void appendSingleByteEncoded(StringBuilder sb, int value, boolean encodeSpaceAsPlus) {
        if (value == 32 && encodeSpaceAsPlus) {
            sb.append('+');
            return;
        }
        sb.append('%');
        sb.append(HEX[value >> 4]);
        sb.append(HEX[value & 0xF]);
    }

    private static final void appendMultiByteEncoded(StringBuilder sb, int value) {
        if (value < 2048) {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xC0 | value >> 6, false);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value & 0x3F, false);
        } else if (value < 65536) {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xE0 | value >> 12, false);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value >> 6 & 0x3F, false);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value & 0x3F, false);
        } else {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xF0 | value >> 18, false);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value >> 12 & 0x3F, false);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value >> 6 & 0x3F, false);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value & 0x3F, false);
        }
    }

    static {
        int i;
        RFC3986_UNRESERVED_CHARS = new BitSet(256);
        RFC3986_RESERVED_CHARS = new BitSet(256);
        RFC3986_SUBDELIM_CHARS = new BitSet(256);
        RFC3986_PCHARS = new BitSet(256);
        BUILT_PATH_UNTOUCHED_CHARS = new BitSet(256);
        BUILT_QUERY_UNTOUCHED_CHARS = new BitSet(256);
        FORM_URL_ENCODED_SAFE_CHARS = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            RFC3986_UNRESERVED_CHARS.set(i);
            FORM_URL_ENCODED_SAFE_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            RFC3986_UNRESERVED_CHARS.set(i);
            FORM_URL_ENCODED_SAFE_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            RFC3986_UNRESERVED_CHARS.set(i);
            FORM_URL_ENCODED_SAFE_CHARS.set(i);
        }
        RFC3986_UNRESERVED_CHARS.set(45);
        RFC3986_UNRESERVED_CHARS.set(46);
        RFC3986_UNRESERVED_CHARS.set(95);
        RFC3986_UNRESERVED_CHARS.set(126);
        RFC3986_SUBDELIM_CHARS.set(33);
        RFC3986_SUBDELIM_CHARS.set(36);
        RFC3986_SUBDELIM_CHARS.set(38);
        RFC3986_SUBDELIM_CHARS.set(39);
        RFC3986_SUBDELIM_CHARS.set(40);
        RFC3986_SUBDELIM_CHARS.set(41);
        RFC3986_SUBDELIM_CHARS.set(42);
        RFC3986_SUBDELIM_CHARS.set(43);
        RFC3986_SUBDELIM_CHARS.set(44);
        RFC3986_SUBDELIM_CHARS.set(59);
        RFC3986_SUBDELIM_CHARS.set(61);
        FORM_URL_ENCODED_SAFE_CHARS.set(45);
        FORM_URL_ENCODED_SAFE_CHARS.set(46);
        FORM_URL_ENCODED_SAFE_CHARS.set(95);
        FORM_URL_ENCODED_SAFE_CHARS.set(42);
        RFC3986_RESERVED_CHARS.set(33);
        RFC3986_RESERVED_CHARS.set(42);
        RFC3986_RESERVED_CHARS.set(39);
        RFC3986_RESERVED_CHARS.set(40);
        RFC3986_RESERVED_CHARS.set(41);
        RFC3986_RESERVED_CHARS.set(59);
        RFC3986_RESERVED_CHARS.set(58);
        RFC3986_RESERVED_CHARS.set(64);
        RFC3986_RESERVED_CHARS.set(38);
        RFC3986_RESERVED_CHARS.set(61);
        RFC3986_RESERVED_CHARS.set(43);
        RFC3986_RESERVED_CHARS.set(36);
        RFC3986_RESERVED_CHARS.set(44);
        RFC3986_RESERVED_CHARS.set(47);
        RFC3986_RESERVED_CHARS.set(63);
        RFC3986_RESERVED_CHARS.set(35);
        RFC3986_RESERVED_CHARS.set(91);
        RFC3986_RESERVED_CHARS.set(93);
        RFC3986_PCHARS.or(RFC3986_UNRESERVED_CHARS);
        RFC3986_PCHARS.or(RFC3986_SUBDELIM_CHARS);
        RFC3986_PCHARS.set(58);
        RFC3986_PCHARS.set(64);
        BUILT_PATH_UNTOUCHED_CHARS.or(RFC3986_PCHARS);
        BUILT_PATH_UNTOUCHED_CHARS.set(37);
        BUILT_PATH_UNTOUCHED_CHARS.set(47);
        BUILT_QUERY_UNTOUCHED_CHARS.or(RFC3986_PCHARS);
        BUILT_QUERY_UNTOUCHED_CHARS.set(37);
        BUILT_QUERY_UNTOUCHED_CHARS.set(47);
        BUILT_QUERY_UNTOUCHED_CHARS.set(63);
        HEX = "0123456789ABCDEF".toCharArray();
    }
}

