/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy;

import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.Channel;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.Channels;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.frame.TooLongFrameException;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpHeaders;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeaders;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyStreamStatus;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.spdy.SpdyVersion;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpdyHttpDecoder
extends OneToOneDecoder {
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, HttpMessage> messageMap;

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int maxContentLength) {
        this(spdyVersion, maxContentLength, new HashMap<Integer, HttpMessage>());
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int maxContentLength, Map<Integer, HttpMessage> messageMap) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.spdyVersion = spdyVersion.getVersion();
        this.maxContentLength = maxContentLength;
        this.messageMap = messageMap;
    }

    protected HttpMessage putMessage(int streamId, HttpMessage message) {
        return this.messageMap.put(streamId, message);
    }

    protected HttpMessage getMessage(int streamId) {
        return this.messageMap.get(streamId);
    }

    protected HttpMessage removeMessage(int streamId) {
        return this.messageMap.remove(streamId);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof SpdySynStreamFrame) {
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamId = spdySynStreamFrame.getStreamId();
            if (SpdyCodecUtil.isServerId(streamId)) {
                int associatedToStreamId = spdySynStreamFrame.getAssociatedToStreamId();
                if (associatedToStreamId == 0) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INVALID_STREAM);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                    return null;
                }
                if (spdySynStreamFrame.isLast()) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                    return null;
                }
                if (spdySynStreamFrame.isTruncated()) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                    return null;
                }
                try {
                    HttpRequest httpRequest = SpdyHttpDecoder.createHttpRequest(this.spdyVersion, spdySynStreamFrame);
                    SpdyHttpHeaders.setStreamId(httpRequest, streamId);
                    SpdyHttpHeaders.setAssociatedToStreamId(httpRequest, associatedToStreamId);
                    SpdyHttpHeaders.setPriority(httpRequest, spdySynStreamFrame.getPriority());
                    return httpRequest;
                }
                catch (Exception e) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                }
            } else {
                if (spdySynStreamFrame.isTruncated()) {
                    DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
                    spdySynReplyFrame.setLast(true);
                    SpdyHeaders.setStatus(this.spdyVersion, spdySynReplyFrame, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                    SpdyHeaders.setVersion(this.spdyVersion, spdySynReplyFrame, HttpVersion.HTTP_1_0);
                    Channels.write(ctx, Channels.future(channel), spdySynReplyFrame);
                    return null;
                }
                try {
                    HttpRequest httpRequest = SpdyHttpDecoder.createHttpRequest(this.spdyVersion, spdySynStreamFrame);
                    SpdyHttpHeaders.setStreamId(httpRequest, streamId);
                    if (spdySynStreamFrame.isLast()) {
                        return httpRequest;
                    }
                    this.putMessage(streamId, httpRequest);
                }
                catch (Exception e) {
                    DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
                    spdySynReplyFrame.setLast(true);
                    SpdyHeaders.setStatus(this.spdyVersion, spdySynReplyFrame, HttpResponseStatus.BAD_REQUEST);
                    SpdyHeaders.setVersion(this.spdyVersion, spdySynReplyFrame, HttpVersion.HTTP_1_0);
                    Channels.write(ctx, Channels.future(channel), spdySynReplyFrame);
                }
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamId = spdySynReplyFrame.getStreamId();
            if (spdySynReplyFrame.isTruncated()) {
                DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                return null;
            }
            try {
                HttpResponse httpResponse = SpdyHttpDecoder.createHttpResponse(this.spdyVersion, spdySynReplyFrame);
                SpdyHttpHeaders.setStreamId(httpResponse, streamId);
                if (spdySynReplyFrame.isLast()) {
                    HttpHeaders.setContentLength(httpResponse, 0L);
                    return httpResponse;
                }
                this.putMessage(streamId, httpResponse);
            }
            catch (Exception e) {
                DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
            }
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamId = spdyHeadersFrame.getStreamId();
            HttpMessage httpMessage = this.getMessage(streamId);
            if (httpMessage == null) {
                if (SpdyCodecUtil.isServerId(streamId)) {
                    if (spdyHeadersFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.INTERNAL_ERROR);
                        Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                        return null;
                    }
                    try {
                        httpMessage = SpdyHttpDecoder.createHttpResponse(this.spdyVersion, spdyHeadersFrame);
                        SpdyHttpHeaders.setStreamId(httpMessage, streamId);
                        if (spdyHeadersFrame.isLast()) {
                            HttpHeaders.setContentLength(httpMessage, 0L);
                            return httpMessage;
                        }
                        this.putMessage(streamId, httpMessage);
                    }
                    catch (Exception e) {
                        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                        Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                        return null;
                    }
                }
                return null;
            }
            if (!spdyHeadersFrame.isTruncated()) {
                for (Map.Entry<String, String> e : spdyHeadersFrame.headers()) {
                    httpMessage.headers().add(e.getKey(), e.getValue());
                }
            }
            if (spdyHeadersFrame.isLast()) {
                HttpHeaders.setContentLength(httpMessage, httpMessage.getContent().readableBytes());
                this.removeMessage(streamId);
                return httpMessage;
            }
        } else if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamId = spdyDataFrame.getStreamId();
            HttpMessage httpMessage = this.getMessage(streamId);
            if (httpMessage == null) {
                return null;
            }
            ChannelBuffer content = httpMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - spdyDataFrame.getData().readableBytes()) {
                this.removeMessage(streamId);
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            if (content == ChannelBuffers.EMPTY_BUFFER) {
                content = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
                content.writeBytes(spdyDataFrame.getData());
                httpMessage.setContent(content);
            } else {
                content.writeBytes(spdyDataFrame.getData());
            }
            if (spdyDataFrame.isLast()) {
                HttpHeaders.setContentLength(httpMessage, content.readableBytes());
                this.removeMessage(streamId);
                return httpMessage;
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            int streamId = spdyRstStreamFrame.getStreamId();
            this.removeMessage(streamId);
        }
        return null;
    }

    private static HttpRequest createHttpRequest(int spdyVersion, SpdyHeadersFrame requestFrame) throws Exception {
        HttpMethod method = SpdyHeaders.getMethod(spdyVersion, requestFrame);
        String url = SpdyHeaders.getUrl(spdyVersion, requestFrame);
        HttpVersion httpVersion = SpdyHeaders.getVersion(spdyVersion, requestFrame);
        SpdyHeaders.removeMethod(spdyVersion, requestFrame);
        SpdyHeaders.removeUrl(spdyVersion, requestFrame);
        SpdyHeaders.removeVersion(spdyVersion, requestFrame);
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(httpVersion, method, url);
        SpdyHeaders.removeScheme(spdyVersion, requestFrame);
        String host = SpdyHeaders.getHost(requestFrame);
        SpdyHeaders.removeHost(requestFrame);
        HttpHeaders.setHost(httpRequest, host);
        for (Map.Entry<String, String> e : requestFrame.headers()) {
            httpRequest.headers().add(e.getKey(), e.getValue());
        }
        HttpHeaders.setKeepAlive(httpRequest, true);
        httpRequest.headers().remove("Transfer-Encoding");
        return httpRequest;
    }

    private static HttpResponse createHttpResponse(int spdyVersion, SpdyHeadersFrame responseFrame) throws Exception {
        HttpResponseStatus status = SpdyHeaders.getStatus(spdyVersion, responseFrame);
        HttpVersion version = SpdyHeaders.getVersion(spdyVersion, responseFrame);
        SpdyHeaders.removeStatus(spdyVersion, responseFrame);
        SpdyHeaders.removeVersion(spdyVersion, responseFrame);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, status);
        for (Map.Entry<String, String> e : responseFrame.headers()) {
            httpResponse.headers().add(e.getKey(), e.getValue());
        }
        HttpHeaders.setKeepAlive(httpResponse, true);
        httpResponse.headers().remove("Transfer-Encoding");
        httpResponse.headers().remove("Trailer");
        return httpResponse;
    }
}

