/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@HubSpotStyle
public interface ChatPostEphemeralMessageParamsIF
extends MessageParams {
    @Override
    @JsonProperty(value="channel")
    public String getChannelId();

    @JsonProperty(value="user")
    public String getUserToSendTo();

    @JsonProperty(value="as_user")
    @Value.Default
    default public boolean getSendAsUser() {
        return false;
    }

    @JsonProperty(value="thread_ts")
    public Optional<String> getThreadTs();

    @JsonProperty(value="link_names")
    @Value.Default
    default public boolean getShouldLinkNames() {
        return true;
    }

    @JsonProperty(value="parse")
    @Value.Default
    default public String getParseMode() {
        return "none";
    }

    @Value.Check
    default public void check() {
        Preconditions.checkState((this.getText().isPresent() && !Strings.isNullOrEmpty((String)this.getText().get()) || !this.getAttachments().isEmpty() ? 1 : 0) != 0, (Object)"Must include text if not providing attachments");
    }
}

