/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.conversations.ConversationUnarchiveParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationUnarchiveParams
implements ConversationUnarchiveParamsIF {
    private final String channelId;

    private ConversationUnarchiveParams(String channelId) {
        this.channelId = channelId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final ConversationUnarchiveParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new ConversationUnarchiveParams(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationUnarchiveParams && this.equalTo((ConversationUnarchiveParams)another);
    }

    private boolean equalTo(ConversationUnarchiveParams another) {
        return this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "ConversationUnarchiveParams{channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator
    static ConversationUnarchiveParams fromJson(Json json) {
        Builder builder = ConversationUnarchiveParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static ConversationUnarchiveParams copyOf(ConversationUnarchiveParamsIF instance) {
        if (instance instanceof ConversationUnarchiveParams) {
            return (ConversationUnarchiveParams)instance;
        }
        return ConversationUnarchiveParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConversationUnarchiveParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof ConversationUnarchiveParamsIF) {
                instance = (ConversationUnarchiveParamsIF)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ConversationUnarchiveParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationUnarchiveParams(this.channelId);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationUnarchiveParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationUnarchiveParamsIF {
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

