/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.ReplySkeleton;
import com.hubspot.slack.client.models.files.SlackFile;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface LiteMessageIF {
    public static final Logger LOG = LoggerFactory.getLogger(LiteMessage.class);

    public String getType();

    public Optional<String> getSubtype();

    public Optional<String> getUser();

    public Optional<String> getBotId();

    public Optional<String> getUsername();

    public String getText();

    public List<Attachment> getAttachments();

    public List<SlackFile> getFiles();

    @JsonProperty(value="ts")
    public String getTimestamp();

    @JsonProperty(value="thread_ts")
    public Optional<String> getThreadTimestamp();

    public Optional<Integer> getReplyCount();

    @JsonProperty(value="reply_users")
    public Optional<List<String>> getReplyUserIds();

    public Optional<Integer> getReplyUsersCount();

    @JsonProperty(value="latest_reply")
    public Optional<String> getLatestReplyTimestamp();

    @Deprecated
    @Value.Default
    default public List<ReplySkeleton> getReplies() {
        LOG.error("Method getReplies() is now deprecated. Slack will stop supporting completely on Oct 18th 2019");
        return Collections.emptyList();
    }
}

