/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@HubSpotStyle
public interface MessageIF {
    public String getType();

    public String getTeam();

    public SlackChannel getChannel();

    public String getUser();

    public String getUsername();

    @JsonProperty(value="ts")
    public String getTimestamp();

    public String getText();

    public Optional<String> getPermalink();

    public List<Attachment> getAttachments();

    @JsonProperty(value="previous_2")
    public Optional<LiteMessage> getPreviousPrevious();

    @JsonProperty(value="previous")
    public Optional<LiteMessage> getPrevious();

    @JsonProperty(value="next")
    public Optional<LiteMessage> getNext();

    @JsonProperty(value="next_2")
    public Optional<LiteMessage> getNextNext();

    @Value.Derived
    default public String getSlackLink() {
        return "slack://channel?team=" + this.getTeam() + "&id=" + this.getChannel().getId() + "&message=" + this.getTimestamp();
    }
}

