/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.SlackChannelIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackChannel
implements SlackChannelIF {
    private final String id;
    private final String name;
    @Nullable
    private final Boolean isArchived;
    @Nullable
    private final Boolean isGeneral;
    private final ChannelType channelType;

    private SlackChannel(String id, String name, @Nullable Boolean isArchived, @Nullable Boolean isGeneral) {
        this.id = id;
        this.name = name;
        this.isArchived = isArchived;
        this.isGeneral = isGeneral;
        this.channelType = Objects.requireNonNull(SlackChannelIF.super.getChannelType(), "channelType");
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsArchived() {
        return Optional.ofNullable(this.isArchived);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsGeneral() {
        return Optional.ofNullable(this.isGeneral);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public ChannelType getChannelType() {
        return this.channelType;
    }

    public final SlackChannel withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackChannel(newValue, this.name, this.isArchived, this.isGeneral);
    }

    public final SlackChannel withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return new SlackChannel(this.id, newValue, this.isArchived, this.isGeneral);
    }

    public final SlackChannel withIsArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isArchived, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, newValue, this.isGeneral);
    }

    public final SlackChannel withIsArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isArchived, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, value, this.isGeneral);
    }

    public final SlackChannel withIsGeneral(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isGeneral, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, newValue);
    }

    public final SlackChannel withIsGeneral(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isGeneral, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannel && this.equalTo((SlackChannel)another);
    }

    private boolean equalTo(SlackChannel another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.isArchived, another.isArchived) && Objects.equals(this.isGeneral, another.isGeneral) && this.channelType.equals((Object)another.channelType);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.isArchived);
        h = h * 17 + Objects.hashCode(this.isGeneral);
        h = h * 17 + this.channelType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackChannel{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.isArchived != null) {
            builder.append(", ");
            builder.append("isArchived=").append(this.isArchived);
        }
        if (this.isGeneral != null) {
            builder.append(", ");
            builder.append("isGeneral=").append(this.isGeneral);
        }
        builder.append(", ");
        builder.append("channelType=").append((Object)this.channelType);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackChannel fromJson(Json json) {
        Builder builder = SlackChannel.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.isArchived != null) {
            builder.setIsArchived(json.isArchived);
        }
        if (json.isGeneral != null) {
            builder.setIsGeneral(json.isGeneral);
        }
        return builder.build();
    }

    public static SlackChannel copyOf(SlackChannelIF instance) {
        if (instance instanceof SlackChannel) {
            return (SlackChannel)instance;
        }
        return SlackChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Boolean isArchived;
        @Nullable
        private Boolean isGeneral;

        private Builder() {
        }

        public final Builder from(SlackChannelIF instance) {
            Optional<Boolean> isGeneralOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setName(instance.getName());
            Optional<Boolean> isArchivedOptional = instance.getIsArchived();
            if (isArchivedOptional.isPresent()) {
                this.setIsArchived(isArchivedOptional);
            }
            if ((isGeneralOptional = instance.getIsGeneral()).isPresent()) {
                this.setIsGeneral(isGeneralOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setIsArchived(@Nullable Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Builder setIsArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived.orElse(null);
            return this;
        }

        public final Builder setIsGeneral(@Nullable Boolean isGeneral) {
            this.isGeneral = isGeneral;
            return this;
        }

        public final Builder setIsGeneral(Optional<Boolean> isGeneral) {
            this.isGeneral = isGeneral.orElse(null);
            return this;
        }

        public SlackChannel build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build SlackChannel, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackChannelIF {
        @Nullable
        String id;
        @Nullable
        String name;
        Optional<Boolean> isArchived = Optional.empty();
        Optional<Boolean> isGeneral = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setIsArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived;
        }

        @JsonProperty
        public void setIsGeneral(Optional<Boolean> isGeneral) {
            this.isGeneral = isGeneral;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsGeneral() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }
    }
}

