/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.DividerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Divider
implements DividerIF {
    private final String type;
    @Nullable
    private final String blockId;

    private Divider(@Nullable String blockId) {
        this.blockId = blockId;
        this.type = Objects.requireNonNull(DividerIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Divider withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Divider(newValue);
    }

    public final Divider withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Divider(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Divider && this.equalTo((Divider)another);
    }

    private boolean equalTo(Divider another) {
        return this.type.equals(another.type) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Divider{");
        builder.append("type=").append(this.type);
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Divider fromJson(Json json) {
        Builder builder = Divider.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Divider copyOf(DividerIF instance) {
        if (instance instanceof Divider) {
            return (Divider)instance;
        }
        return Divider.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DividerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Divider build() throws InvalidImmutableStateException {
            return new Divider(this.blockId);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DividerIF {
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

