/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.InputIF;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Input
implements InputIF {
    private final String type;
    private final Text label;
    private final BlockElement element;
    @Nullable
    private final Text hint;
    @Nullable
    private final Boolean optional;
    @Nullable
    private final String blockId;

    private Input(Text label, BlockElement element) {
        this.label = Objects.requireNonNull(label, "label");
        this.element = Objects.requireNonNull(element, "element");
        this.hint = null;
        this.optional = null;
        this.blockId = null;
        this.type = Objects.requireNonNull(InputIF.super.getType(), "type");
    }

    private Input(Text label, BlockElement element, @Nullable Text hint, @Nullable Boolean optional, @Nullable String blockId) {
        this.label = label;
        this.element = element;
        this.hint = hint;
        this.optional = optional;
        this.blockId = blockId;
        this.type = Objects.requireNonNull(InputIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public BlockElement getElement() {
        return this.element;
    }

    @Override
    @JsonProperty
    public Optional<Text> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    @JsonProperty(value="optional")
    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.optional);
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Input withLabel(Text label) {
        if (this.label == label) {
            return this;
        }
        Text newValue = Objects.requireNonNull(label, "label");
        return new Input(newValue, this.element, this.hint, this.optional, this.blockId);
    }

    public final Input withElement(BlockElement element) {
        if (this.element == element) {
            return this;
        }
        BlockElement newValue = Objects.requireNonNull(element, "element");
        return new Input(this.label, newValue, this.hint, this.optional, this.blockId);
    }

    public final Input withHint(@Nullable Text value) {
        Text newValue = value;
        if (this.hint == newValue) {
            return this;
        }
        return new Input(this.label, this.element, newValue, this.optional, this.blockId);
    }

    public final Input withHint(Optional<Text> optional) {
        Text value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new Input(this.label, this.element, value, this.optional, this.blockId);
    }

    public final Input withOptional(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return new Input(this.label, this.element, this.hint, newValue, this.blockId);
    }

    public final Input withOptional(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return new Input(this.label, this.element, this.hint, value, this.blockId);
    }

    public final Input withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Input(this.label, this.element, this.hint, this.optional, newValue);
    }

    public final Input withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Input(this.label, this.element, this.hint, this.optional, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Input && this.equalTo((Input)another);
    }

    private boolean equalTo(Input another) {
        return this.type.equals(another.type) && this.label.equals(another.label) && this.element.equals(another.element) && Objects.equals(this.hint, another.hint) && Objects.equals(this.optional, another.optional) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.label.hashCode();
        h = h * 17 + this.element.hashCode();
        h = h * 17 + Objects.hashCode(this.hint);
        h = h * 17 + Objects.hashCode(this.optional);
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Input{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("label=").append(this.label);
        builder.append(", ");
        builder.append("element=").append(this.element);
        if (this.hint != null) {
            builder.append(", ");
            builder.append("hint=").append(this.hint);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Input fromJson(Json json) {
        Builder builder = Input.builder();
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.element != null) {
            builder.setElement(json.element);
        }
        if (json.hint != null) {
            builder.setHint(json.hint);
        }
        if (json.optional != null) {
            builder.setOptional(json.optional);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Input of(Text label, BlockElement element) {
        return new Input(label, element);
    }

    public static Input copyOf(InputIF instance) {
        if (instance instanceof Input) {
            return (Input)instance;
        }
        return Input.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_ELEMENT = 2L;
        private long initBits = 3L;
        @Nullable
        private Text label;
        @Nullable
        private BlockElement element;
        @Nullable
        private Text hint;
        @Nullable
        private Boolean optional;
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
            if (object instanceof InputIF) {
                instance = (InputIF)object;
                Optional<Boolean> optionalOptional = instance.isOptional();
                if (optionalOptional.isPresent()) {
                    this.setOptional(optionalOptional);
                }
                this.setLabel(instance.getLabel());
                Optional<Text> hintOptional = instance.getHint();
                if (hintOptional.isPresent()) {
                    this.setHint(hintOptional);
                }
                this.setElement(instance.getElement());
            }
        }

        public final Builder setLabel(Text label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setElement(BlockElement element) {
            this.element = Objects.requireNonNull(element, "element");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setHint(@Nullable Text hint) {
            this.hint = hint;
            return this;
        }

        public final Builder setHint(Optional<Text> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder setOptional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Builder setOptional(Optional<Boolean> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Input build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Input(this.label, this.element, this.hint, this.optional, this.blockId);
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean elementIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            if (!this.elementIsSet()) {
                attributes.add("element");
            }
            return "Cannot build Input, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements InputIF {
        @Nullable
        Text label;
        @Nullable
        BlockElement element;
        Optional<Text> hint = Optional.empty();
        Optional<Boolean> optional = Optional.empty();
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setLabel(Text label) {
            this.label = label;
        }

        @JsonProperty
        public void setElement(BlockElement element) {
            this.element = element;
        }

        @JsonProperty
        public void setHint(Optional<Text> hint) {
            this.hint = hint;
        }

        @JsonProperty(value="optional")
        public void setOptional(Optional<Boolean> optional) {
            this.optional = optional;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockElement getElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getHint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

