/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.SectionIF;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Section
implements SectionIF {
    private final String type;
    private final Text text;
    private final List<Text> fields;
    @Nullable
    private final BlockElement accessory;
    @Nullable
    private final String blockId;

    private Section(Text text) {
        this.text = Objects.requireNonNull(text, "text");
        this.fields = Collections.emptyList();
        this.accessory = null;
        this.blockId = null;
        this.type = Objects.requireNonNull(SectionIF.super.getType(), "type");
    }

    private Section(Text text, List<Text> fields, @Nullable BlockElement accessory, @Nullable String blockId) {
        this.text = text;
        this.fields = fields;
        this.accessory = accessory;
        this.blockId = blockId;
        this.type = Objects.requireNonNull(SectionIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public List<Text> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty
    public Optional<BlockElement> getAccessory() {
        return Optional.ofNullable(this.accessory);
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Section withText(Text text) {
        if (this.text == text) {
            return this;
        }
        Text newValue = Objects.requireNonNull(text, "text");
        return new Section(newValue, this.fields, this.accessory, this.blockId);
    }

    public final Section withFields(Text ... elements) {
        List<Text> newValue = Section.createUnmodifiableList(false, Section.createSafeList(Arrays.asList(elements), true, false));
        return new Section(this.text, newValue, this.accessory, this.blockId);
    }

    public final Section withFields(Iterable<? extends Text> elements) {
        if (this.fields == elements) {
            return this;
        }
        List<Text> newValue = Section.createUnmodifiableList(false, Section.createSafeList(elements, true, false));
        return new Section(this.text, newValue, this.accessory, this.blockId);
    }

    public final Section withAccessory(@Nullable BlockElement value) {
        BlockElement newValue = value;
        if (this.accessory == newValue) {
            return this;
        }
        return new Section(this.text, this.fields, newValue, this.blockId);
    }

    public final Section withAccessory(Optional<BlockElement> optional) {
        BlockElement value = optional.orElse(null);
        if (this.accessory == value) {
            return this;
        }
        return new Section(this.text, this.fields, value, this.blockId);
    }

    public final Section withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Section(this.text, this.fields, this.accessory, newValue);
    }

    public final Section withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Section(this.text, this.fields, this.accessory, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Section && this.equalTo((Section)another);
    }

    private boolean equalTo(Section another) {
        return this.type.equals(another.type) && this.text.equals(another.text) && this.fields.equals(another.fields) && Objects.equals(this.accessory, another.accessory) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.text.hashCode();
        h = h * 17 + this.fields.hashCode();
        h = h * 17 + Objects.hashCode(this.accessory);
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Section{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("fields=").append(this.fields);
        if (this.accessory != null) {
            builder.append(", ");
            builder.append("accessory=").append(this.accessory);
        }
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Section fromJson(Json json) {
        Builder builder = Section.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.fields != null) {
            builder.addAllFields(json.fields);
        }
        if (json.accessory != null) {
            builder.setAccessory(json.accessory);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Section of(Text text) {
        return new Section(text);
    }

    public static Section copyOf(SectionIF instance) {
        if (instance instanceof Section) {
            return (Section)instance;
        }
        return Section.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private Text text;
        private List<Text> fields = new ArrayList<Text>();
        @Nullable
        private BlockElement accessory;
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SectionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
            if (object instanceof SectionIF) {
                instance = (SectionIF)object;
                this.addAllFields(instance.getFields());
                Optional<BlockElement> accessoryOptional = instance.getAccessory();
                if (accessoryOptional.isPresent()) {
                    this.setAccessory(accessoryOptional);
                }
                this.setText(instance.getText());
            }
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addFields(Text element) {
            this.fields.add(Objects.requireNonNull(element, "fields element"));
            return this;
        }

        public final Builder addFields(Text ... elements) {
            for (Text element : elements) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
            }
            return this;
        }

        public final Builder setFields(Iterable<? extends Text> elements) {
            this.fields.clear();
            return this.addAllFields(elements);
        }

        public final Builder addAllFields(Iterable<? extends Text> elements) {
            for (Text text : elements) {
                this.fields.add(Objects.requireNonNull(text, "fields element"));
            }
            return this;
        }

        public final Builder setAccessory(@Nullable BlockElement accessory) {
            this.accessory = accessory;
            return this;
        }

        public final Builder setAccessory(Optional<BlockElement> accessory) {
            this.accessory = accessory.orElse(null);
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Section build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Section(this.text, Section.createUnmodifiableList(true, this.fields), this.accessory, this.blockId);
        }

        private boolean textIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build Section, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SectionIF {
        @Nullable
        Text text;
        List<Text> fields = Collections.emptyList();
        Optional<BlockElement> accessory = Optional.empty();
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @JsonProperty
        public void setFields(List<Text> fields) {
            this.fields = fields;
        }

        @JsonProperty
        public void setAccessory(Optional<BlockElement> accessory) {
            this.accessory = accessory;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Text> getFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BlockElement> getAccessory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

