/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ChannelsMultiSelectMenuIF;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChannelsMultiSelectMenu
implements ChannelsMultiSelectMenuIF {
    private final String type;
    private final Text placeholder;
    private final String actionId;
    private final List<String> initialConversationIds;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private ChannelsMultiSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialConversationIds = Collections.emptyList();
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ChannelsMultiSelectMenuIF.super.getType(), "type");
    }

    private ChannelsMultiSelectMenu(Text placeholder, String actionId, List<String> initialConversationIds, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialConversationIds = initialConversationIds;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ChannelsMultiSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="initial_channels")
    public List<String> getInitialConversationIds() {
        return this.initialConversationIds;
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final ChannelsMultiSelectMenu withPlaceholder(Text placeholder) {
        if (this.placeholder == placeholder) {
            return this;
        }
        Text newValue = Objects.requireNonNull(placeholder, "placeholder");
        return new ChannelsMultiSelectMenu(newValue, this.actionId, this.initialConversationIds, this.confirmationDialog);
    }

    public final ChannelsMultiSelectMenu withActionId(String actionId) {
        if (this.actionId.equals(actionId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionId, "actionId");
        return new ChannelsMultiSelectMenu(this.placeholder, newValue, this.initialConversationIds, this.confirmationDialog);
    }

    public final ChannelsMultiSelectMenu withInitialConversationIds(String ... elements) {
        List<String> newValue = ChannelsMultiSelectMenu.createUnmodifiableList(false, ChannelsMultiSelectMenu.createSafeList(Arrays.asList(elements), true, false));
        return new ChannelsMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final ChannelsMultiSelectMenu withInitialConversationIds(Iterable<String> elements) {
        if (this.initialConversationIds == elements) {
            return this;
        }
        List<String> newValue = ChannelsMultiSelectMenu.createUnmodifiableList(false, ChannelsMultiSelectMenu.createSafeList(elements, true, false));
        return new ChannelsMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final ChannelsMultiSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new ChannelsMultiSelectMenu(this.placeholder, this.actionId, this.initialConversationIds, newValue);
    }

    public final ChannelsMultiSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new ChannelsMultiSelectMenu(this.placeholder, this.actionId, this.initialConversationIds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsMultiSelectMenu && this.equalTo((ChannelsMultiSelectMenu)another);
    }

    private boolean equalTo(ChannelsMultiSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && this.initialConversationIds.equals(another.initialConversationIds) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.placeholder.hashCode();
        h = h * 17 + this.actionId.hashCode();
        h = h * 17 + this.initialConversationIds.hashCode();
        h = h * 17 + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsMultiSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("initialConversationIds=").append(this.initialConversationIds);
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChannelsMultiSelectMenu fromJson(Json json) {
        Builder builder = ChannelsMultiSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialConversationIds != null) {
            builder.addAllInitialConversationIds(json.initialConversationIds);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static ChannelsMultiSelectMenu of(Text placeholder, String actionId) {
        return new ChannelsMultiSelectMenu(placeholder, actionId);
    }

    public static ChannelsMultiSelectMenu copyOf(ChannelsMultiSelectMenuIF instance) {
        if (instance instanceof ChannelsMultiSelectMenu) {
            return (ChannelsMultiSelectMenu)instance;
        }
        return ChannelsMultiSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        private List<String> initialConversationIds = new ArrayList<String>();
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(ChannelsMultiSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPlaceholder(instance.getPlaceholder());
            this.setActionId(instance.getActionId());
            this.addAllInitialConversationIds(instance.getInitialConversationIds());
            Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
            if (confirmationDialogOptional.isPresent()) {
                this.setConfirmationDialog(confirmationDialogOptional);
            }
            return this;
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addInitialConversationIds(String element) {
            this.initialConversationIds.add(Objects.requireNonNull(element, "initialConversationIds element"));
            return this;
        }

        public final Builder addInitialConversationIds(String ... elements) {
            for (String element : elements) {
                this.initialConversationIds.add(Objects.requireNonNull(element, "initialConversationIds element"));
            }
            return this;
        }

        public final Builder setInitialConversationIds(Iterable<String> elements) {
            this.initialConversationIds.clear();
            return this.addAllInitialConversationIds(elements);
        }

        public final Builder addAllInitialConversationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.initialConversationIds.add(Objects.requireNonNull(element, "initialConversationIds element"));
            }
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public ChannelsMultiSelectMenu build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChannelsMultiSelectMenu(this.placeholder, this.actionId, ChannelsMultiSelectMenu.createUnmodifiableList(true, this.initialConversationIds), this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build ChannelsMultiSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChannelsMultiSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        List<String> initialConversationIds = Collections.emptyList();
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="initial_channels")
        public void setInitialConversationIds(List<String> initialConversationIds) {
            this.initialConversationIds = initialConversationIds;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getInitialConversationIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

