/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.UserSelectMenuIF;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UserSelectMenu
implements UserSelectMenuIF {
    private final String type;
    private final Text placeholder;
    private final String actionId;
    @Nullable
    private final String initialUserId;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private UserSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialUserId = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(UserSelectMenuIF.super.getType(), "type");
    }

    private UserSelectMenu(Text placeholder, String actionId, @Nullable String initialUserId, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialUserId = initialUserId;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(UserSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="initial_user")
    public Optional<String> getInitialUserId() {
        return Optional.ofNullable(this.initialUserId);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final UserSelectMenu withPlaceholder(Text placeholder) {
        if (this.placeholder == placeholder) {
            return this;
        }
        Text newValue = Objects.requireNonNull(placeholder, "placeholder");
        return new UserSelectMenu(newValue, this.actionId, this.initialUserId, this.confirmationDialog);
    }

    public final UserSelectMenu withActionId(String actionId) {
        if (this.actionId.equals(actionId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionId, "actionId");
        return new UserSelectMenu(this.placeholder, newValue, this.initialUserId, this.confirmationDialog);
    }

    public final UserSelectMenu withInitialUserId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialUserId, newValue)) {
            return this;
        }
        return new UserSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final UserSelectMenu withInitialUserId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialUserId, value)) {
            return this;
        }
        return new UserSelectMenu(this.placeholder, this.actionId, value, this.confirmationDialog);
    }

    public final UserSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new UserSelectMenu(this.placeholder, this.actionId, this.initialUserId, newValue);
    }

    public final UserSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new UserSelectMenu(this.placeholder, this.actionId, this.initialUserId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserSelectMenu && this.equalTo((UserSelectMenu)another);
    }

    private boolean equalTo(UserSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && Objects.equals(this.initialUserId, another.initialUserId) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.placeholder.hashCode();
        h = h * 17 + this.actionId.hashCode();
        h = h * 17 + Objects.hashCode(this.initialUserId);
        h = h * 17 + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UserSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.initialUserId != null) {
            builder.append(", ");
            builder.append("initialUserId=").append(this.initialUserId);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UserSelectMenu fromJson(Json json) {
        Builder builder = UserSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialUserId != null) {
            builder.setInitialUserId(json.initialUserId);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static UserSelectMenu of(Text placeholder, String actionId) {
        return new UserSelectMenu(placeholder, actionId);
    }

    public static UserSelectMenu copyOf(UserSelectMenuIF instance) {
        if (instance instanceof UserSelectMenu) {
            return (UserSelectMenu)instance;
        }
        return UserSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        @Nullable
        private String initialUserId;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(UserSelectMenuIF instance) {
            Optional<ConfirmationDialog> confirmationDialogOptional;
            Objects.requireNonNull(instance, "instance");
            this.setPlaceholder(instance.getPlaceholder());
            this.setActionId(instance.getActionId());
            Optional<String> initialUserIdOptional = instance.getInitialUserId();
            if (initialUserIdOptional.isPresent()) {
                this.setInitialUserId(initialUserIdOptional);
            }
            if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                this.setConfirmationDialog(confirmationDialogOptional);
            }
            return this;
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setInitialUserId(@Nullable String initialUserId) {
            this.initialUserId = initialUserId;
            return this;
        }

        public final Builder setInitialUserId(Optional<String> initialUserId) {
            this.initialUserId = initialUserId.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public UserSelectMenu build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UserSelectMenu(this.placeholder, this.actionId, this.initialUserId, this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build UserSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UserSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        Optional<String> initialUserId = Optional.empty();
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="initial_user")
        public void setInitialUserId(Optional<String> initialUserId) {
            this.initialUserId = initialUserId;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

