/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialogIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConfirmationDialog
implements ConfirmationDialogIF {
    private final Text title;
    private final Text text;
    private final Text confirmButtonText;
    private final Text denyButtonText;

    private ConfirmationDialog(Text title, Text text, Text confirmButtonText, Text denyButtonText) {
        this.title = Objects.requireNonNull(title, "title");
        this.text = Objects.requireNonNull(text, "text");
        this.confirmButtonText = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
        this.denyButtonText = Objects.requireNonNull(denyButtonText, "denyButtonText");
    }

    private ConfirmationDialog(ConfirmationDialog original, Text title, Text text, Text confirmButtonText, Text denyButtonText) {
        this.title = title;
        this.text = text;
        this.confirmButtonText = confirmButtonText;
        this.denyButtonText = denyButtonText;
    }

    @Override
    @JsonProperty
    public Text getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="confirm")
    public Text getConfirmButtonText() {
        return this.confirmButtonText;
    }

    @Override
    @JsonProperty(value="deny")
    public Text getDenyButtonText() {
        return this.denyButtonText;
    }

    public final ConfirmationDialog withTitle(Text title) {
        if (this.title == title) {
            return this;
        }
        Text newValue = Objects.requireNonNull(title, "title");
        return new ConfirmationDialog(this, newValue, this.text, this.confirmButtonText, this.denyButtonText);
    }

    public final ConfirmationDialog withText(Text text) {
        if (this.text == text) {
            return this;
        }
        Text newValue = Objects.requireNonNull(text, "text");
        return new ConfirmationDialog(this, this.title, newValue, this.confirmButtonText, this.denyButtonText);
    }

    public final ConfirmationDialog withConfirmButtonText(Text confirmButtonText) {
        if (this.confirmButtonText == confirmButtonText) {
            return this;
        }
        Text newValue = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
        return new ConfirmationDialog(this, this.title, this.text, newValue, this.denyButtonText);
    }

    public final ConfirmationDialog withDenyButtonText(Text denyButtonText) {
        if (this.denyButtonText == denyButtonText) {
            return this;
        }
        Text newValue = Objects.requireNonNull(denyButtonText, "denyButtonText");
        return new ConfirmationDialog(this, this.title, this.text, this.confirmButtonText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConfirmationDialog && this.equalTo((ConfirmationDialog)another);
    }

    private boolean equalTo(ConfirmationDialog another) {
        return this.title.equals(another.title) && this.text.equals(another.text) && this.confirmButtonText.equals(another.confirmButtonText) && this.denyButtonText.equals(another.denyButtonText);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.text.hashCode();
        h = h * 17 + this.confirmButtonText.hashCode();
        h = h * 17 + this.denyButtonText.hashCode();
        return h;
    }

    public String toString() {
        return "ConfirmationDialog{title=" + this.title + ", text=" + this.text + ", confirmButtonText=" + this.confirmButtonText + ", denyButtonText=" + this.denyButtonText + "}";
    }

    @Deprecated
    @JsonCreator
    static ConfirmationDialog fromJson(Json json) {
        Builder builder = ConfirmationDialog.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.confirmButtonText != null) {
            builder.setConfirmButtonText(json.confirmButtonText);
        }
        if (json.denyButtonText != null) {
            builder.setDenyButtonText(json.denyButtonText);
        }
        return builder.build();
    }

    public static ConfirmationDialog of(Text title, Text text, Text confirmButtonText, Text denyButtonText) {
        return new ConfirmationDialog(title, text, confirmButtonText, denyButtonText);
    }

    public static ConfirmationDialog copyOf(ConfirmationDialogIF instance) {
        if (instance instanceof ConfirmationDialog) {
            return (ConfirmationDialog)instance;
        }
        return ConfirmationDialog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_CONFIRM_BUTTON_TEXT = 4L;
        private static final long INIT_BIT_DENY_BUTTON_TEXT = 8L;
        private long initBits = 15L;
        @Nullable
        private Text title;
        @Nullable
        private Text text;
        @Nullable
        private Text confirmButtonText;
        @Nullable
        private Text denyButtonText;

        private Builder() {
        }

        public final Builder from(ConfirmationDialogIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTitle(instance.getTitle());
            this.setText(instance.getText());
            this.setConfirmButtonText(instance.getConfirmButtonText());
            this.setDenyButtonText(instance.getDenyButtonText());
            return this;
        }

        public final Builder setTitle(Text title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setConfirmButtonText(Text confirmButtonText) {
            this.confirmButtonText = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setDenyButtonText(Text denyButtonText) {
            this.denyButtonText = Objects.requireNonNull(denyButtonText, "denyButtonText");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ConfirmationDialog build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConfirmationDialog(null, this.title, this.text, this.confirmButtonText, this.denyButtonText);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean confirmButtonTextIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean denyButtonTextIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.confirmButtonTextIsSet()) {
                attributes.add("confirmButtonText");
            }
            if (!this.denyButtonTextIsSet()) {
                attributes.add("denyButtonText");
            }
            return "Cannot build ConfirmationDialog, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConfirmationDialogIF {
        @Nullable
        Text title;
        @Nullable
        Text text;
        @Nullable
        Text confirmButtonText;
        @Nullable
        Text denyButtonText;

        Json() {
        }

        @JsonProperty
        public void setTitle(Text title) {
            this.title = title;
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @JsonProperty(value="confirm")
        public void setConfirmButtonText(Text confirmButtonText) {
            this.confirmButtonText = confirmButtonText;
        }

        @JsonProperty(value="deny")
        public void setDenyButtonText(Text denyButtonText) {
            this.denyButtonText = denyButtonText;
        }

        @Override
        public Text getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getConfirmButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getDenyButtonText() {
            throw new UnsupportedOperationException();
        }
    }
}

