/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.commands;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.commands.SlashCommandSubmissionIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlashCommandSubmission
implements SlashCommandSubmissionIF {
    private final String token;
    private final String teamId;
    private final String teamDomain;
    @Nullable
    private final String enterpriseId;
    @Nullable
    private final String enterpriseName;
    private final String channelId;
    private final String channelName;
    private final String userId;
    private final String command;
    private final String text;
    private final String responseUrl;
    private final String triggerId;
    private final String userName;

    private SlashCommandSubmission(String token, String teamId, String teamDomain, @Nullable String enterpriseId, @Nullable String enterpriseName, String channelId, String channelName, String userId, String command, String text, String responseUrl, String triggerId, String userName) {
        this.token = token;
        this.teamId = teamId;
        this.teamDomain = teamDomain;
        this.enterpriseId = enterpriseId;
        this.enterpriseName = enterpriseName;
        this.channelId = channelId;
        this.channelName = channelName;
        this.userId = userId;
        this.command = command;
        this.text = text;
        this.responseUrl = responseUrl;
        this.triggerId = triggerId;
        this.userName = userName;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty
    public String getTeamDomain() {
        return this.teamDomain;
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseId() {
        return Optional.ofNullable(this.enterpriseId);
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseName() {
        return Optional.ofNullable(this.enterpriseName);
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    @JsonProperty
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    @Deprecated
    public String getUserName() {
        return this.userName;
    }

    public final SlashCommandSubmission withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new SlashCommandSubmission(newValue, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withTeamId(String teamId) {
        if (this.teamId.equals(teamId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(teamId, "teamId");
        return new SlashCommandSubmission(this.token, newValue, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withTeamDomain(String teamDomain) {
        if (this.teamDomain.equals(teamDomain)) {
            return this;
        }
        String newValue = Objects.requireNonNull(teamDomain, "teamDomain");
        return new SlashCommandSubmission(this.token, this.teamId, newValue, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withEnterpriseId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseId, newValue)) {
            return this;
        }
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, newValue, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withEnterpriseId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseId, value)) {
            return this;
        }
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, value, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withEnterpriseName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseName, newValue)) {
            return this;
        }
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, newValue, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withEnterpriseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseName, value)) {
            return this;
        }
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, value, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, newValue, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withChannelName(String channelName) {
        if (this.channelName.equals(channelName)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelName, "channelName");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, newValue, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, newValue, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withCommand(String command) {
        if (this.command.equals(command)) {
            return this;
        }
        String newValue = Objects.requireNonNull(command, "command");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, newValue, this.text, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withText(String text) {
        if (this.text.equals(text)) {
            return this;
        }
        String newValue = Objects.requireNonNull(text, "text");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, newValue, this.responseUrl, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withResponseUrl(String responseUrl) {
        if (this.responseUrl.equals(responseUrl)) {
            return this;
        }
        String newValue = Objects.requireNonNull(responseUrl, "responseUrl");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, newValue, this.triggerId, this.userName);
    }

    public final SlashCommandSubmission withTriggerId(String triggerId) {
        if (this.triggerId.equals(triggerId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(triggerId, "triggerId");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, newValue, this.userName);
    }

    @Deprecated
    public final SlashCommandSubmission withUserName(String userName) {
        if (this.userName.equals(userName)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userName, "userName");
        return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlashCommandSubmission && this.equalTo((SlashCommandSubmission)another);
    }

    private boolean equalTo(SlashCommandSubmission another) {
        return this.token.equals(another.token) && this.teamId.equals(another.teamId) && this.teamDomain.equals(another.teamDomain) && Objects.equals(this.enterpriseId, another.enterpriseId) && Objects.equals(this.enterpriseName, another.enterpriseName) && this.channelId.equals(another.channelId) && this.channelName.equals(another.channelName) && this.userId.equals(another.userId) && this.command.equals(another.command) && this.text.equals(another.text) && this.responseUrl.equals(another.responseUrl) && this.triggerId.equals(another.triggerId) && this.userName.equals(another.userName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.teamId.hashCode();
        h = h * 17 + this.teamDomain.hashCode();
        h = h * 17 + Objects.hashCode(this.enterpriseId);
        h = h * 17 + Objects.hashCode(this.enterpriseName);
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.channelName.hashCode();
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + this.command.hashCode();
        h = h * 17 + this.text.hashCode();
        h = h * 17 + this.responseUrl.hashCode();
        h = h * 17 + this.triggerId.hashCode();
        h = h * 17 + this.userName.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlashCommandSubmission{");
        builder.append("token=").append(this.token);
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        builder.append(", ");
        builder.append("teamDomain=").append(this.teamDomain);
        if (this.enterpriseId != null) {
            builder.append(", ");
            builder.append("enterpriseId=").append(this.enterpriseId);
        }
        if (this.enterpriseName != null) {
            builder.append(", ");
            builder.append("enterpriseName=").append(this.enterpriseName);
        }
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("channelName=").append(this.channelName);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("command=").append(this.command);
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("responseUrl=").append(this.responseUrl);
        builder.append(", ");
        builder.append("triggerId=").append(this.triggerId);
        builder.append(", ");
        builder.append("userName=").append(this.userName);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlashCommandSubmission fromJson(Json json) {
        Builder builder = SlashCommandSubmission.builder();
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.teamDomain != null) {
            builder.setTeamDomain(json.teamDomain);
        }
        if (json.enterpriseId != null) {
            builder.setEnterpriseId(json.enterpriseId);
        }
        if (json.enterpriseName != null) {
            builder.setEnterpriseName(json.enterpriseName);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.channelName != null) {
            builder.setChannelName(json.channelName);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.command != null) {
            builder.setCommand(json.command);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.responseUrl != null) {
            builder.setResponseUrl(json.responseUrl);
        }
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.userName != null) {
            builder.setUserName(json.userName);
        }
        return builder.build();
    }

    public static SlashCommandSubmission copyOf(SlashCommandSubmissionIF instance) {
        if (instance instanceof SlashCommandSubmission) {
            return (SlashCommandSubmission)instance;
        }
        return SlashCommandSubmission.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_TEAM_ID = 2L;
        private static final long INIT_BIT_TEAM_DOMAIN = 4L;
        private static final long INIT_BIT_CHANNEL_ID = 8L;
        private static final long INIT_BIT_CHANNEL_NAME = 16L;
        private static final long INIT_BIT_USER_ID = 32L;
        private static final long INIT_BIT_COMMAND = 64L;
        private static final long INIT_BIT_TEXT = 128L;
        private static final long INIT_BIT_RESPONSE_URL = 256L;
        private static final long INIT_BIT_TRIGGER_ID = 512L;
        private static final long INIT_BIT_USER_NAME = 1024L;
        private long initBits = 2047L;
        @Nullable
        private String token;
        @Nullable
        private String teamId;
        @Nullable
        private String teamDomain;
        @Nullable
        private String enterpriseId;
        @Nullable
        private String enterpriseName;
        @Nullable
        private String channelId;
        @Nullable
        private String channelName;
        @Nullable
        private String userId;
        @Nullable
        private String command;
        @Nullable
        private String text;
        @Nullable
        private String responseUrl;
        @Nullable
        private String triggerId;
        @Nullable
        private String userName;

        private Builder() {
        }

        public final Builder from(SlashCommandSubmissionIF instance) {
            Optional<String> enterpriseNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.setToken(instance.getToken());
            this.setTeamId(instance.getTeamId());
            this.setTeamDomain(instance.getTeamDomain());
            Optional<String> enterpriseIdOptional = instance.getEnterpriseId();
            if (enterpriseIdOptional.isPresent()) {
                this.setEnterpriseId(enterpriseIdOptional);
            }
            if ((enterpriseNameOptional = instance.getEnterpriseName()).isPresent()) {
                this.setEnterpriseName(enterpriseNameOptional);
            }
            this.setChannelId(instance.getChannelId());
            this.setChannelName(instance.getChannelName());
            this.setUserId(instance.getUserId());
            this.setCommand(instance.getCommand());
            this.setText(instance.getText());
            this.setResponseUrl(instance.getResponseUrl());
            this.setTriggerId(instance.getTriggerId());
            this.setUserName(instance.getUserName());
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTeamDomain(String teamDomain) {
            this.teamDomain = Objects.requireNonNull(teamDomain, "teamDomain");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setEnterpriseId(@Nullable String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public final Builder setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId.orElse(null);
            return this;
        }

        public final Builder setEnterpriseName(@Nullable String enterpriseName) {
            this.enterpriseName = enterpriseName;
            return this;
        }

        public final Builder setEnterpriseName(Optional<String> enterpriseName) {
            this.enterpriseName = enterpriseName.orElse(null);
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setChannelName(String channelName) {
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setCommand(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setResponseUrl(String responseUrl) {
            this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @Deprecated
        public final Builder setUserName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public SlashCommandSubmission build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlashCommandSubmission(this.token, this.teamId, this.teamDomain, this.enterpriseId, this.enterpriseName, this.channelId, this.channelName, this.userId, this.command, this.text, this.responseUrl, this.triggerId, this.userName);
        }

        private boolean tokenIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean teamDomainIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean channelNameIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean commandIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean responseUrlIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private boolean userNameIsSet() {
            return (this.initBits & 0x400L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            if (!this.teamDomainIsSet()) {
                attributes.add("teamDomain");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.channelNameIsSet()) {
                attributes.add("channelName");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.commandIsSet()) {
                attributes.add("command");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.responseUrlIsSet()) {
                attributes.add("responseUrl");
            }
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.userNameIsSet()) {
                attributes.add("userName");
            }
            return "Cannot build SlashCommandSubmission, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlashCommandSubmissionIF {
        @Nullable
        String token;
        @Nullable
        String teamId;
        @Nullable
        String teamDomain;
        Optional<String> enterpriseId = Optional.empty();
        Optional<String> enterpriseName = Optional.empty();
        @Nullable
        String channelId;
        @Nullable
        String channelName;
        @Nullable
        String userId;
        @Nullable
        String command;
        @Nullable
        String text;
        @Nullable
        String responseUrl;
        @Nullable
        String triggerId;
        @Nullable
        String userName;

        Json() {
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setTeamDomain(String teamDomain) {
            this.teamDomain = teamDomain;
        }

        @JsonProperty
        public void setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @JsonProperty
        public void setEnterpriseName(Optional<String> enterpriseName) {
            this.enterpriseName = enterpriseName;
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @JsonProperty
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setCommand(String command) {
            this.command = command;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setResponseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResponseUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }
    }
}

