/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.conversations.ConversationIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Conversation
implements ConversationIF {
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean channel;
    @Nullable
    private final Boolean group;
    @Nullable
    private final Boolean mpim;
    @Nullable
    private final Boolean im;
    @Nullable
    private final Boolean archived;
    @Nullable
    private final Boolean general;

    private Conversation(String id, @Nullable String name, @Nullable Boolean channel, @Nullable Boolean group, @Nullable Boolean mpim, @Nullable Boolean im, @Nullable Boolean archived, @Nullable Boolean general) {
        this.id = id;
        this.name = name;
        this.channel = channel;
        this.group = group;
        this.mpim = mpim;
        this.im = im;
        this.archived = archived;
        this.general = general;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="is_channel")
    public Optional<Boolean> isChannel() {
        return Optional.ofNullable(this.channel);
    }

    @Override
    @JsonProperty(value="is_group")
    public Optional<Boolean> isGroup() {
        return Optional.ofNullable(this.group);
    }

    @Override
    @JsonProperty(value="is_mpim")
    public Optional<Boolean> isMpim() {
        return Optional.ofNullable(this.mpim);
    }

    @Override
    @JsonProperty(value="is_im")
    public Optional<Boolean> isIm() {
        return Optional.ofNullable(this.im);
    }

    @Override
    @JsonProperty(value="is_archived")
    public Optional<Boolean> isArchived() {
        return Optional.ofNullable(this.archived);
    }

    @Override
    @JsonProperty(value="is_general")
    public Optional<Boolean> isGeneral() {
        return Optional.ofNullable(this.general);
    }

    public final Conversation withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new Conversation(newValue, this.name, this.channel, this.group, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new Conversation(this.id, newValue, this.channel, this.group, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new Conversation(this.id, value, this.channel, this.group, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withChannel(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.channel, newValue)) {
            return this;
        }
        return new Conversation(this.id, this.name, newValue, this.group, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withChannel(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.channel, value)) {
            return this;
        }
        return new Conversation(this.id, this.name, value, this.group, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withGroup(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.group, newValue)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, newValue, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withGroup(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.group, value)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, value, this.mpim, this.im, this.archived, this.general);
    }

    public final Conversation withMpim(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.mpim, newValue)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, newValue, this.im, this.archived, this.general);
    }

    public final Conversation withMpim(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.mpim, value)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, value, this.im, this.archived, this.general);
    }

    public final Conversation withIm(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.im, newValue)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, newValue, this.archived, this.general);
    }

    public final Conversation withIm(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.im, value)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, value, this.archived, this.general);
    }

    public final Conversation withArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.archived, newValue)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, this.im, newValue, this.general);
    }

    public final Conversation withArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.archived, value)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, this.im, value, this.general);
    }

    public final Conversation withGeneral(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.general, newValue)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, this.im, this.archived, newValue);
    }

    public final Conversation withGeneral(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.general, value)) {
            return this;
        }
        return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, this.im, this.archived, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Conversation && this.equalTo((Conversation)another);
    }

    private boolean equalTo(Conversation another) {
        return this.id.equals(another.id) && Objects.equals(this.name, another.name) && Objects.equals(this.channel, another.channel) && Objects.equals(this.group, another.group) && Objects.equals(this.mpim, another.mpim) && Objects.equals(this.im, another.im) && Objects.equals(this.archived, another.archived) && Objects.equals(this.general, another.general);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.channel);
        h = h * 17 + Objects.hashCode(this.group);
        h = h * 17 + Objects.hashCode(this.mpim);
        h = h * 17 + Objects.hashCode(this.im);
        h = h * 17 + Objects.hashCode(this.archived);
        h = h * 17 + Objects.hashCode(this.general);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Conversation{");
        builder.append("id=").append(this.id);
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.channel != null) {
            builder.append(", ");
            builder.append("channel=").append(this.channel);
        }
        if (this.group != null) {
            builder.append(", ");
            builder.append("group=").append(this.group);
        }
        if (this.mpim != null) {
            builder.append(", ");
            builder.append("mpim=").append(this.mpim);
        }
        if (this.im != null) {
            builder.append(", ");
            builder.append("im=").append(this.im);
        }
        if (this.archived != null) {
            builder.append(", ");
            builder.append("archived=").append(this.archived);
        }
        if (this.general != null) {
            builder.append(", ");
            builder.append("general=").append(this.general);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Conversation fromJson(Json json) {
        Builder builder = Conversation.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.group != null) {
            builder.setGroup(json.group);
        }
        if (json.mpim != null) {
            builder.setMpim(json.mpim);
        }
        if (json.im != null) {
            builder.setIm(json.im);
        }
        if (json.archived != null) {
            builder.setArchived(json.archived);
        }
        if (json.general != null) {
            builder.setGeneral(json.general);
        }
        return builder.build();
    }

    public static Conversation copyOf(ConversationIF instance) {
        if (instance instanceof Conversation) {
            return (Conversation)instance;
        }
        return Conversation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Boolean channel;
        @Nullable
        private Boolean group;
        @Nullable
        private Boolean mpim;
        @Nullable
        private Boolean im;
        @Nullable
        private Boolean archived;
        @Nullable
        private Boolean general;

        private Builder() {
        }

        public final Builder from(ConversationIF instance) {
            Optional<Boolean> generalOptional;
            Optional<Boolean> archivedOptional;
            Optional<Boolean> imOptional;
            Optional<Boolean> mpimOptional;
            Optional<Boolean> groupOptional;
            Optional<Boolean> channelOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            Optional<String> nameOptional = instance.getName();
            if (nameOptional.isPresent()) {
                this.setName(nameOptional);
            }
            if ((channelOptional = instance.isChannel()).isPresent()) {
                this.setChannel(channelOptional);
            }
            if ((groupOptional = instance.isGroup()).isPresent()) {
                this.setGroup(groupOptional);
            }
            if ((mpimOptional = instance.isMpim()).isPresent()) {
                this.setMpim(mpimOptional);
            }
            if ((imOptional = instance.isIm()).isPresent()) {
                this.setIm(imOptional);
            }
            if ((archivedOptional = instance.isArchived()).isPresent()) {
                this.setArchived(archivedOptional);
            }
            if ((generalOptional = instance.isGeneral()).isPresent()) {
                this.setGeneral(generalOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder setChannel(@Nullable Boolean channel) {
            this.channel = channel;
            return this;
        }

        public final Builder setChannel(Optional<Boolean> channel) {
            this.channel = channel.orElse(null);
            return this;
        }

        public final Builder setGroup(@Nullable Boolean group) {
            this.group = group;
            return this;
        }

        public final Builder setGroup(Optional<Boolean> group) {
            this.group = group.orElse(null);
            return this;
        }

        public final Builder setMpim(@Nullable Boolean mpim) {
            this.mpim = mpim;
            return this;
        }

        public final Builder setMpim(Optional<Boolean> mpim) {
            this.mpim = mpim.orElse(null);
            return this;
        }

        public final Builder setIm(@Nullable Boolean im) {
            this.im = im;
            return this;
        }

        public final Builder setIm(Optional<Boolean> im) {
            this.im = im.orElse(null);
            return this;
        }

        public final Builder setArchived(@Nullable Boolean archived) {
            this.archived = archived;
            return this;
        }

        public final Builder setArchived(Optional<Boolean> archived) {
            this.archived = archived.orElse(null);
            return this;
        }

        public final Builder setGeneral(@Nullable Boolean general) {
            this.general = general;
            return this;
        }

        public final Builder setGeneral(Optional<Boolean> general) {
            this.general = general.orElse(null);
            return this;
        }

        public Conversation build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Conversation(this.id, this.name, this.channel, this.group, this.mpim, this.im, this.archived, this.general);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build Conversation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationIF {
        @Nullable
        String id;
        Optional<String> name = Optional.empty();
        Optional<Boolean> channel = Optional.empty();
        Optional<Boolean> group = Optional.empty();
        Optional<Boolean> mpim = Optional.empty();
        Optional<Boolean> im = Optional.empty();
        Optional<Boolean> archived = Optional.empty();
        Optional<Boolean> general = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="is_channel")
        public void setChannel(Optional<Boolean> channel) {
            this.channel = channel;
        }

        @JsonProperty(value="is_group")
        public void setGroup(Optional<Boolean> group) {
            this.group = group;
        }

        @JsonProperty(value="is_mpim")
        public void setMpim(Optional<Boolean> mpim) {
            this.mpim = mpim;
        }

        @JsonProperty(value="is_im")
        public void setIm(Optional<Boolean> im) {
            this.im = im;
        }

        @JsonProperty(value="is_archived")
        public void setArchived(Optional<Boolean> archived) {
            this.archived = archived;
        }

        @JsonProperty(value="is_general")
        public void setGeneral(Optional<Boolean> general) {
            this.general = general;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isMpim() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isIm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isGeneral() {
            throw new UnsupportedOperationException();
        }
    }
}

