/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackDialogFormTextElement;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public abstract class AbstractSlackFormTextareaElement
extends AbstractSlackDialogFormTextElement {
    @Override
    @Value.Default
    public SlackFormElementTypes getType() {
        return SlackFormElementTypes.TEXTAREA;
    }

    @Value.Check
    public void validate() {
        super.validateBaseTextElementProps();
        if (this.getMaxLength() > 3000) {
            throw new IllegalStateException("Form text area cannot have max length > 3000 chars, got " + this.getMaxLength());
        }
        if (this.getMinLength() > 3000) {
            throw new IllegalStateException("Form text area cannot have min length > 3000 chars, got " + this.getMinLength());
        }
        if (this.getValue().isPresent() && this.getValue().get().length() > 3000) {
            throw new IllegalStateException("Value cannot exceed 3000 chars, got '" + this.getValue().get() + "'");
        }
    }
}

