/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface SlackFormOptionIF {
    public String getLabel();

    public String getValue();

    @Value.Check
    default public void validate() {
        if (Strings.isNullOrEmpty((String)this.getLabel())) {
            throw new IllegalStateException("Must provide a label");
        }
        String label = this.getLabel();
        if (label.length() > 75) {
            throw new IllegalStateException("Label cannot exceed 75 chars - '" + label + "'");
        }
        if (Strings.isNullOrEmpty((String)this.getValue())) {
            throw new IllegalStateException("Must provide a value");
        }
        String value = this.getValue();
        if (value.length() > 75) {
            throw new IllegalStateException("Value cannot exceed 75 chars - '" + value + "'");
        }
    }
}

