/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.SlackDataSource;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormSelectElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackFormSelectElement
extends AbstractSlackFormSelectElement {
    private final SlackFormElementTypes type;
    private final SlackDataSource dataSource;
    private final List<SlackFormOption> options;
    private final List<SlackFormOptionGroup> optionGroups;
    @Nullable
    private final String value;
    private final List<SlackFormOption> selectedOptions;
    @Nullable
    private final Integer minQueryLength;
    private final String name;
    private final String label;
    @Nullable
    private final String placeholder;
    @Nullable
    private final Boolean optional;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackFormSelectElement(Builder builder) {
        this.options = SlackFormSelectElement.createUnmodifiableList(true, builder.options);
        this.optionGroups = SlackFormSelectElement.createUnmodifiableList(true, builder.optionGroups);
        this.value = builder.value;
        this.selectedOptions = SlackFormSelectElement.createUnmodifiableList(true, builder.selectedOptions);
        this.minQueryLength = builder.minQueryLength;
        this.name = builder.name;
        this.label = builder.label;
        this.placeholder = builder.placeholder;
        this.optional = builder.optional;
        if (builder.type != null) {
            this.initShim.setType(builder.type);
        }
        if (builder.dataSource != null) {
            this.initShim.setDataSource(builder.dataSource);
        }
        this.type = this.initShim.getType();
        this.dataSource = this.initShim.getDataSource();
        this.initShim = null;
    }

    private SlackFormSelectElement(SlackFormElementTypes type, SlackDataSource dataSource, List<SlackFormOption> options, List<SlackFormOptionGroup> optionGroups, @Nullable String value, List<SlackFormOption> selectedOptions, @Nullable Integer minQueryLength, String name, String label, @Nullable String placeholder, @Nullable Boolean optional) {
        this.type = type;
        this.dataSource = dataSource;
        this.options = options;
        this.optionGroups = optionGroups;
        this.value = value;
        this.selectedOptions = selectedOptions;
        this.minQueryLength = minQueryLength;
        this.name = name;
        this.label = label;
        this.placeholder = placeholder;
        this.optional = optional;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public SlackFormElementTypes getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty
    public SlackDataSource getDataSource() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDataSource() : this.dataSource;
    }

    @Override
    @JsonProperty
    public List<SlackFormOption> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    public List<SlackFormOptionGroup> getOptionGroups() {
        return this.optionGroups;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public List<SlackFormOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMinQueryLength() {
        return Optional.ofNullable(this.minQueryLength);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public Optional<String> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty(value="optional")
    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.optional);
    }

    public final SlackFormSelectElement withType(SlackFormElementTypes type) {
        if (this.type == type) {
            return this;
        }
        SlackFormElementTypes newValue = Objects.requireNonNull(type, "type");
        return SlackFormSelectElement.validate(new SlackFormSelectElement(newValue, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withDataSource(SlackDataSource dataSource) {
        if (this.dataSource == dataSource) {
            return this;
        }
        SlackDataSource newValue = Objects.requireNonNull(dataSource, "dataSource");
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, newValue, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withOptions(SlackFormOption ... elements) {
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, newValue, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withOptions(Iterable<? extends SlackFormOption> elements) {
        if (this.options == elements) {
            return this;
        }
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(elements, true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, newValue, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withOptionGroups(SlackFormOptionGroup ... elements) {
        List<SlackFormOptionGroup> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, newValue, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
        if (this.optionGroups == elements) {
            return this;
        }
        List<SlackFormOptionGroup> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(elements, true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, newValue, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, newValue, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withSelectedOptions(SlackFormOption ... elements) {
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, newValue, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withSelectedOptions(Iterable<? extends SlackFormOption> elements) {
        if (this.selectedOptions == elements) {
            return this;
        }
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(elements, true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, newValue, this.minQueryLength, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withMinQueryLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.minQueryLength, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, newValue, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withMinQueryLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.minQueryLength, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, newValue, this.label, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withLabel(String label) {
        if (this.label.equals(label)) {
            return this;
        }
        String newValue = Objects.requireNonNull(label, "label");
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, newValue, this.placeholder, this.optional));
    }

    public final SlackFormSelectElement withPlaceholder(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.placeholder, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, newValue, this.optional));
    }

    public final SlackFormSelectElement withPlaceholder(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.placeholder, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, value, this.optional));
    }

    public final SlackFormSelectElement withOptional(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, newValue));
    }

    public final SlackFormSelectElement withOptional(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.type, this.dataSource, this.options, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength, this.name, this.label, this.placeholder, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFormSelectElement && this.equalTo((SlackFormSelectElement)another);
    }

    private boolean equalTo(SlackFormSelectElement another) {
        return this.type.equals((Object)another.type) && this.dataSource.equals((Object)another.dataSource) && this.options.equals(another.options) && this.optionGroups.equals(another.optionGroups) && Objects.equals(this.value, another.value) && this.selectedOptions.equals(another.selectedOptions) && Objects.equals(this.minQueryLength, another.minQueryLength) && this.name.equals(another.name) && this.label.equals(another.label) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.optional, another.optional);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.dataSource.hashCode();
        h = h * 17 + this.options.hashCode();
        h = h * 17 + this.optionGroups.hashCode();
        h = h * 17 + Objects.hashCode(this.value);
        h = h * 17 + this.selectedOptions.hashCode();
        h = h * 17 + Objects.hashCode(this.minQueryLength);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.label.hashCode();
        h = h * 17 + Objects.hashCode(this.placeholder);
        h = h * 17 + Objects.hashCode(this.optional);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackFormSelectElement{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("dataSource=").append((Object)this.dataSource);
        builder.append(", ");
        builder.append("options=").append(this.options);
        builder.append(", ");
        builder.append("optionGroups=").append(this.optionGroups);
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        builder.append(", ");
        builder.append("selectedOptions=").append(this.selectedOptions);
        if (this.minQueryLength != null) {
            builder.append(", ");
            builder.append("minQueryLength=").append(this.minQueryLength);
        }
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("label=").append(this.label);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackFormSelectElement fromJson(Json json) {
        Builder builder = SlackFormSelectElement.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.dataSource != null) {
            builder.setDataSource(json.dataSource);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.optionGroups != null) {
            builder.addAllOptionGroups(json.optionGroups);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.selectedOptions != null) {
            builder.addAllSelectedOptions(json.selectedOptions);
        }
        if (json.minQueryLength != null) {
            builder.setMinQueryLength(json.minQueryLength);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.optional != null) {
            builder.setOptional(json.optional);
        }
        return builder.build();
    }

    private static SlackFormSelectElement validate(SlackFormSelectElement instance) {
        instance.validate();
        return instance;
    }

    public static SlackFormSelectElement copyOf(AbstractSlackFormSelectElement instance) {
        if (instance instanceof SlackFormSelectElement) {
            return (SlackFormSelectElement)instance;
        }
        return SlackFormSelectElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackFormElementTypes type;
        @Nullable
        private SlackDataSource dataSource;
        private List<SlackFormOption> options = new ArrayList<SlackFormOption>();
        private List<SlackFormOptionGroup> optionGroups = new ArrayList<SlackFormOptionGroup>();
        @Nullable
        private String value;
        private List<SlackFormOption> selectedOptions = new ArrayList<SlackFormOption>();
        @Nullable
        private Integer minQueryLength;
        @Nullable
        private String name;
        @Nullable
        private String label;
        @Nullable
        private String placeholder;
        @Nullable
        private Boolean optional;

        private Builder() {
        }

        public final Builder from(SlackDialogFormElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackFormSelectElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackDialogFormElement instance;
            long bits = 0L;
            if (object instanceof SlackDialogFormElement) {
                instance = (SlackDialogFormElement)object;
                this.setName(instance.getName());
                Optional<Boolean> optionalOptional = instance.isOptional();
                if (optionalOptional.isPresent()) {
                    this.setOptional(optionalOptional);
                }
                this.setLabel(instance.getLabel());
                Optional<String> placeholderOptional = instance.getPlaceholder();
                if (placeholderOptional.isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractSlackFormSelectElement) {
                instance = (AbstractSlackFormSelectElement)object;
                Optional<Integer> minQueryLengthOptional = ((AbstractSlackFormSelectElement)instance).getMinQueryLength();
                if (minQueryLengthOptional.isPresent()) {
                    this.setMinQueryLength(minQueryLengthOptional);
                }
                this.addAllOptions(((AbstractSlackFormSelectElement)instance).getOptions());
                this.addAllSelectedOptions(((AbstractSlackFormSelectElement)instance).getSelectedOptions());
                this.addAllOptionGroups(((AbstractSlackFormSelectElement)instance).getOptionGroups());
                if ((bits & 1L) == 0L) {
                    this.setType(((AbstractSlackFormSelectElement)instance).getType());
                    bits |= 1L;
                }
                this.setDataSource(((AbstractSlackFormSelectElement)instance).getDataSource());
                Optional<String> valueOptional = ((AbstractSlackFormSelectElement)instance).getValue();
                if (valueOptional.isPresent()) {
                    this.setValue(valueOptional);
                }
            }
        }

        public final Builder setType(SlackFormElementTypes type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public final Builder setDataSource(SlackDataSource dataSource) {
            this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
            return this;
        }

        public final Builder addOptions(SlackFormOption element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(SlackFormOption ... elements) {
            for (SlackFormOption element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends SlackFormOption> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends SlackFormOption> elements) {
            for (SlackFormOption slackFormOption : elements) {
                this.options.add(Objects.requireNonNull(slackFormOption, "options element"));
            }
            return this;
        }

        public final Builder addOptionGroups(SlackFormOptionGroup element) {
            this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            return this;
        }

        public final Builder addOptionGroups(SlackFormOptionGroup ... elements) {
            for (SlackFormOptionGroup element : elements) {
                this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            }
            return this;
        }

        public final Builder setOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
            this.optionGroups.clear();
            return this.addAllOptionGroups(elements);
        }

        public final Builder addAllOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
            for (SlackFormOptionGroup slackFormOptionGroup : elements) {
                this.optionGroups.add(Objects.requireNonNull(slackFormOptionGroup, "optionGroups element"));
            }
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder addSelectedOptions(SlackFormOption element) {
            this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            return this;
        }

        public final Builder addSelectedOptions(SlackFormOption ... elements) {
            for (SlackFormOption element : elements) {
                this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setSelectedOptions(Iterable<? extends SlackFormOption> elements) {
            this.selectedOptions.clear();
            return this.addAllSelectedOptions(elements);
        }

        public final Builder addAllSelectedOptions(Iterable<? extends SlackFormOption> elements) {
            for (SlackFormOption slackFormOption : elements) {
                this.selectedOptions.add(Objects.requireNonNull(slackFormOption, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
            this.minQueryLength = minQueryLength;
            return this;
        }

        public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength.orElse(null);
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setOptional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Builder setOptional(Optional<Boolean> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public SlackFormSelectElement build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return SlackFormSelectElement.validate(new SlackFormSelectElement(this));
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean labelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            return "Cannot build SlackFormSelectElement, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackFormSelectElement {
        @Nullable
        SlackFormElementTypes type;
        @Nullable
        SlackDataSource dataSource;
        List<SlackFormOption> options = Collections.emptyList();
        List<SlackFormOptionGroup> optionGroups = Collections.emptyList();
        Optional<String> value = Optional.empty();
        List<SlackFormOption> selectedOptions = Collections.emptyList();
        Optional<Integer> minQueryLength = Optional.empty();
        @Nullable
        String name;
        @Nullable
        String label;
        Optional<String> placeholder = Optional.empty();
        Optional<Boolean> optional = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(SlackFormElementTypes type) {
            this.type = type;
        }

        @JsonProperty
        public void setDataSource(SlackDataSource dataSource) {
            this.dataSource = dataSource;
        }

        @JsonProperty
        public void setOptions(List<SlackFormOption> options) {
            this.options = options;
        }

        @JsonProperty
        public void setOptionGroups(List<SlackFormOptionGroup> optionGroups) {
            this.optionGroups = optionGroups;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setSelectedOptions(List<SlackFormOption> selectedOptions) {
            this.selectedOptions = selectedOptions;
        }

        @JsonProperty
        public void setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty(value="optional")
        public void setOptional(Optional<Boolean> optional) {
            this.optional = optional;
        }

        @Override
        public SlackFormElementTypes getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackDataSource getDataSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFormOption> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFormOptionGroup> getOptionGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFormOption> getSelectedOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMinQueryLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isOptional() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private SlackFormElementTypes type;
        private int typeStage;
        private SlackDataSource dataSource;
        private int dataSourceStage;

        private InitShim() {
        }

        SlackFormElementTypes getType() {
            if (this.typeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.typeStage == 0) {
                this.typeStage = -1;
                this.type = Objects.requireNonNull(SlackFormSelectElement.super.getType(), "type");
                this.typeStage = 1;
            }
            return this.type;
        }

        void setType(SlackFormElementTypes type) {
            this.type = type;
            this.typeStage = 1;
        }

        SlackDataSource getDataSource() {
            if (this.dataSourceStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.dataSourceStage == 0) {
                this.dataSourceStage = -1;
                this.dataSource = Objects.requireNonNull(SlackFormSelectElement.super.getDataSource(), "dataSource");
                this.dataSourceStage = 1;
            }
            return this.dataSource;
        }

        void setDataSource(SlackDataSource dataSource) {
            this.dataSource = dataSource;
            this.dataSourceStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeStage == -1) {
                attributes.add("type");
            }
            if (this.dataSourceStage == -1) {
                attributes.add("dataSource");
            }
            return "Cannot build SlackFormSelectElement, attribute initializers form cycle" + attributes;
        }
    }
}

