/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventSkeletonIF;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackEventSkeleton
implements SlackEventSkeletonIF {
    @Nullable
    private final String channelMaybe;
    private final SlackEventType type;
    private final String ts;

    private SlackEventSkeleton(@Nullable String channelMaybe, SlackEventType type, String ts) {
        this.channelMaybe = channelMaybe;
        this.type = type;
        this.ts = ts;
    }

    @Override
    @JsonProperty(value="channel")
    public Optional<String> getChannelMaybe() {
        return Optional.ofNullable(this.channelMaybe);
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final SlackEventSkeleton withChannelMaybe(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channelMaybe, newValue)) {
            return this;
        }
        return new SlackEventSkeleton(newValue, this.type, this.ts);
    }

    public final SlackEventSkeleton withChannelMaybe(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelMaybe, value)) {
            return this;
        }
        return new SlackEventSkeleton(value, this.type, this.ts);
    }

    public final SlackEventSkeleton withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackEventSkeleton(this.channelMaybe, newValue, this.ts);
    }

    public final SlackEventSkeleton withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new SlackEventSkeleton(this.channelMaybe, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventSkeleton && this.equalTo((SlackEventSkeleton)another);
    }

    private boolean equalTo(SlackEventSkeleton another) {
        return Objects.equals(this.channelMaybe, another.channelMaybe) && this.type.equals((Object)another.type) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.channelMaybe);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventSkeleton{");
        if (this.channelMaybe != null) {
            builder.append("channelMaybe=").append(this.channelMaybe);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackEventSkeleton fromJson(Json json) {
        Builder builder = SlackEventSkeleton.builder();
        if (json.channelMaybe != null) {
            builder.setChannelMaybe(json.channelMaybe);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static SlackEventSkeleton copyOf(SlackEventSkeletonIF instance) {
        if (instance instanceof SlackEventSkeleton) {
            return (SlackEventSkeleton)instance;
        }
        return SlackEventSkeleton.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelMaybe;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(SlackEventSkeletonIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackEvent instance;
            Optional<String> channelMaybeOptional;
            if (object instanceof SlackEventSkeletonIF && (channelMaybeOptional = (instance = (SlackEventSkeletonIF)object).getChannelMaybe()).isPresent()) {
                this.setChannelMaybe(channelMaybeOptional);
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
                this.setTs(instance.getTs());
            }
        }

        public final Builder setChannelMaybe(@Nullable String channelMaybe) {
            this.channelMaybe = channelMaybe;
            return this;
        }

        public final Builder setChannelMaybe(Optional<String> channelMaybe) {
            this.channelMaybe = channelMaybe.orElse(null);
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackEventSkeleton build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackEventSkeleton(this.channelMaybe, this.type, this.ts);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackEventSkeleton, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackEventSkeletonIF {
        Optional<String> channelMaybe = Optional.empty();
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelMaybe(Optional<String> channelMaybe) {
            this.channelMaybe = channelMaybe;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public Optional<String> getChannelMaybe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

