/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelUnarchiveEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackChannelUnarchiveEvent
implements SlackChannelUnarchiveEventIF {
    private final String channelId;
    private final String unarchivedByUserId;
    private final SlackEventType type;

    private SlackChannelUnarchiveEvent(String channelId, String unarchivedByUserId, SlackEventType type) {
        this.channelId = channelId;
        this.unarchivedByUserId = unarchivedByUserId;
        this.type = type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="user")
    public String getUnarchivedByUserId() {
        return this.unarchivedByUserId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackChannelUnarchiveEvent withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackChannelUnarchiveEvent(newValue, this.unarchivedByUserId, this.type);
    }

    public final SlackChannelUnarchiveEvent withUnarchivedByUserId(String unarchivedByUserId) {
        if (this.unarchivedByUserId.equals(unarchivedByUserId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(unarchivedByUserId, "unarchivedByUserId");
        return new SlackChannelUnarchiveEvent(this.channelId, newValue, this.type);
    }

    public final SlackChannelUnarchiveEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackChannelUnarchiveEvent(this.channelId, this.unarchivedByUserId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelUnarchiveEvent && this.equalTo((SlackChannelUnarchiveEvent)another);
    }

    private boolean equalTo(SlackChannelUnarchiveEvent another) {
        return this.channelId.equals(another.channelId) && this.unarchivedByUserId.equals(another.unarchivedByUserId) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.unarchivedByUserId.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelUnarchiveEvent{channelId=" + this.channelId + ", unarchivedByUserId=" + this.unarchivedByUserId + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackChannelUnarchiveEvent fromJson(Json json) {
        Builder builder = SlackChannelUnarchiveEvent.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.unarchivedByUserId != null) {
            builder.setUnarchivedByUserId(json.unarchivedByUserId);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackChannelUnarchiveEvent copyOf(SlackChannelUnarchiveEventIF instance) {
        if (instance instanceof SlackChannelUnarchiveEvent) {
            return (SlackChannelUnarchiveEvent)instance;
        }
        return SlackChannelUnarchiveEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_UNARCHIVED_BY_USER_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String channelId;
        @Nullable
        private String unarchivedByUserId;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackChannelUnarchiveEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackEvent instance;
            if (object instanceof SlackChannelUnarchiveEventIF) {
                instance = (SlackChannelUnarchiveEventIF)object;
                this.setChannelId(instance.getChannelId());
                this.setUnarchivedByUserId(instance.getUnarchivedByUserId());
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUnarchivedByUserId(String unarchivedByUserId) {
            this.unarchivedByUserId = Objects.requireNonNull(unarchivedByUserId, "unarchivedByUserId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackChannelUnarchiveEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackChannelUnarchiveEvent(this.channelId, this.unarchivedByUserId, this.type);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean unarchivedByUserIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.unarchivedByUserIdIsSet()) {
                attributes.add("unarchivedByUserId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackChannelUnarchiveEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackChannelUnarchiveEventIF {
        @Nullable
        String channelId;
        @Nullable
        String unarchivedByUserId;
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="user")
        public void setUnarchivedByUserId(String unarchivedByUserId) {
            this.unarchivedByUserId = unarchivedByUserId;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUnarchivedByUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

