/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.util.ReplyIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Reply
implements ReplyIF {
    private final String user;
    private final String ts;

    private Reply(String user, String ts) {
        this.user = user;
        this.ts = ts;
    }

    @Override
    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final Reply withUser(String user) {
        if (this.user.equals(user)) {
            return this;
        }
        String newValue = Objects.requireNonNull(user, "user");
        return new Reply(newValue, this.ts);
    }

    public final Reply withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new Reply(this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Reply && this.equalTo((Reply)another);
    }

    private boolean equalTo(Reply another) {
        return this.user.equals(another.user) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        return "Reply{user=" + this.user + ", ts=" + this.ts + "}";
    }

    @Deprecated
    @JsonCreator
    static Reply fromJson(Json json) {
        Builder builder = Reply.builder();
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static Reply copyOf(ReplyIF instance) {
        if (instance instanceof Reply) {
            return (Reply)instance;
        }
        return Reply.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String user;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(ReplyIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUser(instance.getUser());
            this.setTs(instance.getTs());
            return this;
        }

        public final Builder setUser(String user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Reply build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Reply(this.user, this.ts);
        }

        private boolean userIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build Reply, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ReplyIF {
        @Nullable
        String user;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty
        public void setUser(String user) {
            this.user = user;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

