/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum SlackFileType {
    TEXT("text"),
    GIF("gif"),
    CSV("csv"),
    JPG("jpg"),
    PNG("png"),
    UNKNOWN("unknown");

    final String type;

    private SlackFileType(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static SlackFileType parse(String field) {
        return Stream.of(SlackFileType.values()).filter(val -> val.getType().equalsIgnoreCase(field)).findFirst().orElseThrow(() -> new IllegalArgumentException(field + " doesn't match any known slack file type"));
    }
}

