/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.files.SlackFileType;
import com.hubspot.slack.client.models.files.SlackTextFileCore;
import com.hubspot.slack.client.models.files.SlackTextFileIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackTextFile
implements SlackTextFileIF {
    private final SlackFileType filetype;
    private final String editLink;
    private final String preview;
    private final String previewHighlight;
    private final String lines;
    private final String linesMore;
    private final boolean previewTruncated;
    private final String id;
    private final long createdEpochSeconds;
    private final long timestampEpochSeconds;
    private final String name;
    private final String title;
    private final String mimetype;
    private final String prettyType;
    private final String userId;
    private final boolean editable;
    private final long size;
    private final String mode;
    private final boolean external;
    private final boolean isPublic;
    private final boolean publicUrlShared;
    private final boolean displayAsBot;
    private final String username;
    private final String urlPrivate;
    @Nullable
    private final String urlPrivateDownload;
    private final String permalink;
    @Nullable
    private final String permalinkPublic;
    private final int commentsCount;
    @Nullable
    private final Boolean starred;
    private final List<String> channelIds;
    private final List<String> groupIds;
    private final List<String> imIds;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackTextFile(Builder builder) {
        this.editLink = builder.editLink;
        this.preview = builder.preview;
        this.previewHighlight = builder.previewHighlight;
        this.lines = builder.lines;
        this.linesMore = builder.linesMore;
        this.previewTruncated = builder.previewTruncated;
        this.id = builder.id;
        this.createdEpochSeconds = builder.createdEpochSeconds;
        this.timestampEpochSeconds = builder.timestampEpochSeconds;
        this.name = builder.name;
        this.title = builder.title;
        this.mimetype = builder.mimetype;
        this.prettyType = builder.prettyType;
        this.userId = builder.userId;
        this.editable = builder.editable;
        this.size = builder.size;
        this.mode = builder.mode;
        this.external = builder.external;
        this.isPublic = builder.isPublic;
        this.publicUrlShared = builder.publicUrlShared;
        this.displayAsBot = builder.displayAsBot;
        this.username = builder.username;
        this.urlPrivate = builder.urlPrivate;
        this.urlPrivateDownload = builder.urlPrivateDownload;
        this.permalink = builder.permalink;
        this.permalinkPublic = builder.permalinkPublic;
        this.starred = builder.starred;
        this.channelIds = SlackTextFile.createUnmodifiableList(true, builder.channelIds);
        this.groupIds = SlackTextFile.createUnmodifiableList(true, builder.groupIds);
        this.imIds = SlackTextFile.createUnmodifiableList(true, builder.imIds);
        if (builder.filetype != null) {
            this.initShim.setFiletype(builder.filetype);
        }
        if (builder.commentsCountIsSet()) {
            this.initShim.setCommentsCount(builder.commentsCount);
        }
        this.filetype = this.initShim.getFiletype();
        this.commentsCount = this.initShim.getCommentsCount();
        this.initShim = null;
    }

    private SlackTextFile(SlackFileType filetype, String editLink, String preview, String previewHighlight, String lines, String linesMore, boolean previewTruncated, String id, long createdEpochSeconds, long timestampEpochSeconds, String name, String title, String mimetype, String prettyType, String userId, boolean editable, long size, String mode, boolean external, boolean isPublic, boolean publicUrlShared, boolean displayAsBot, String username, String urlPrivate, @Nullable String urlPrivateDownload, String permalink, @Nullable String permalinkPublic, int commentsCount, @Nullable Boolean starred, List<String> channelIds, List<String> groupIds, List<String> imIds) {
        this.filetype = filetype;
        this.editLink = editLink;
        this.preview = preview;
        this.previewHighlight = previewHighlight;
        this.lines = lines;
        this.linesMore = linesMore;
        this.previewTruncated = previewTruncated;
        this.id = id;
        this.createdEpochSeconds = createdEpochSeconds;
        this.timestampEpochSeconds = timestampEpochSeconds;
        this.name = name;
        this.title = title;
        this.mimetype = mimetype;
        this.prettyType = prettyType;
        this.userId = userId;
        this.editable = editable;
        this.size = size;
        this.mode = mode;
        this.external = external;
        this.isPublic = isPublic;
        this.publicUrlShared = publicUrlShared;
        this.displayAsBot = displayAsBot;
        this.username = username;
        this.urlPrivate = urlPrivate;
        this.urlPrivateDownload = urlPrivateDownload;
        this.permalink = permalink;
        this.permalinkPublic = permalinkPublic;
        this.commentsCount = commentsCount;
        this.starred = starred;
        this.channelIds = channelIds;
        this.groupIds = groupIds;
        this.imIds = imIds;
        this.initShim = null;
    }

    private SlackFileType getFiletypeInitialize() {
        return SlackTextFileIF.super.getFiletype();
    }

    private int getCommentsCountInitialize() {
        return SlackTextFileIF.super.getCommentsCount();
    }

    @Override
    @JsonProperty
    public SlackFileType getFiletype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFiletype() : this.filetype;
    }

    @Override
    @JsonProperty
    public String getEditLink() {
        return this.editLink;
    }

    @Override
    @JsonProperty
    public String getPreview() {
        return this.preview;
    }

    @Override
    @JsonProperty
    public String getPreviewHighlight() {
        return this.previewHighlight;
    }

    @Override
    @JsonProperty
    public String getLines() {
        return this.lines;
    }

    @Override
    @JsonProperty
    public String getLinesMore() {
        return this.linesMore;
    }

    @Override
    @JsonProperty(value="preview_is_truncated")
    public boolean isPreviewTruncated() {
        return this.previewTruncated;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created")
    public long getCreatedEpochSeconds() {
        return this.createdEpochSeconds;
    }

    @Override
    @JsonProperty(value="timestamp")
    public long getTimestampEpochSeconds() {
        return this.timestampEpochSeconds;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    @JsonProperty
    public String getPrettyType() {
        return this.prettyType;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @Override
    @JsonProperty
    public String getMode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="is_external")
    public boolean isExternal() {
        return this.external;
    }

    @Override
    @JsonProperty(value="is_public")
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    @JsonProperty
    public boolean isPublicUrlShared() {
        return this.publicUrlShared;
    }

    @Override
    @JsonProperty
    public boolean getDisplayAsBot() {
        return this.displayAsBot;
    }

    @Override
    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty
    public String getUrlPrivate() {
        return this.urlPrivate;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrlPrivateDownload() {
        return Optional.ofNullable(this.urlPrivateDownload);
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        return this.permalink;
    }

    @Override
    @JsonProperty
    public Optional<String> getPermalinkPublic() {
        return Optional.ofNullable(this.permalinkPublic);
    }

    @Override
    @JsonProperty
    public int getCommentsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommentsCount() : this.commentsCount;
    }

    @Override
    @JsonProperty(value="is_starred")
    public Optional<Boolean> isStarred() {
        return Optional.ofNullable(this.starred);
    }

    @Override
    @JsonProperty(value="channels")
    public List<String> getChannelIds() {
        return this.channelIds;
    }

    @Override
    @JsonProperty(value="groups")
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    @JsonProperty(value="ims")
    public List<String> getImIds() {
        return this.imIds;
    }

    public final SlackTextFile withFiletype(SlackFileType filetype) {
        if (this.filetype == filetype) {
            return this;
        }
        SlackFileType newValue = Objects.requireNonNull(filetype, "filetype");
        return new SlackTextFile(newValue, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withEditLink(String editLink) {
        if (this.editLink.equals(editLink)) {
            return this;
        }
        String newValue = Objects.requireNonNull(editLink, "editLink");
        return new SlackTextFile(this.filetype, newValue, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPreview(String preview) {
        if (this.preview.equals(preview)) {
            return this;
        }
        String newValue = Objects.requireNonNull(preview, "preview");
        return new SlackTextFile(this.filetype, this.editLink, newValue, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPreviewHighlight(String previewHighlight) {
        if (this.previewHighlight.equals(previewHighlight)) {
            return this;
        }
        String newValue = Objects.requireNonNull(previewHighlight, "previewHighlight");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, newValue, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withLines(String lines) {
        if (this.lines.equals(lines)) {
            return this;
        }
        String newValue = Objects.requireNonNull(lines, "lines");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, newValue, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withLinesMore(String linesMore) {
        if (this.linesMore.equals(linesMore)) {
            return this;
        }
        String newValue = Objects.requireNonNull(linesMore, "linesMore");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, newValue, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPreviewTruncated(boolean previewTruncated) {
        if (this.previewTruncated == previewTruncated) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, newValue, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withCreatedEpochSeconds(long createdEpochSeconds) {
        if (this.createdEpochSeconds == createdEpochSeconds) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withTimestampEpochSeconds(long timestampEpochSeconds) {
        if (this.timestampEpochSeconds == timestampEpochSeconds) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, newValue, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withTitle(String title) {
        if (this.title.equals(title)) {
            return this;
        }
        String newValue = Objects.requireNonNull(title, "title");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, newValue, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withMimetype(String mimetype) {
        if (this.mimetype.equals(mimetype)) {
            return this;
        }
        String newValue = Objects.requireNonNull(mimetype, "mimetype");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, newValue, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPrettyType(String prettyType) {
        if (this.prettyType.equals(prettyType)) {
            return this;
        }
        String newValue = Objects.requireNonNull(prettyType, "prettyType");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, newValue, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, newValue, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withEditable(boolean editable) {
        if (this.editable == editable) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withSize(long size) {
        if (this.size == size) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withMode(String mode) {
        if (this.mode.equals(mode)) {
            return this;
        }
        String newValue = Objects.requireNonNull(mode, "mode");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, newValue, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withExternal(boolean external) {
        if (this.external == external) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withIsPublic(boolean isPublic) {
        if (this.isPublic == isPublic) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPublicUrlShared(boolean publicUrlShared) {
        if (this.publicUrlShared == publicUrlShared) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withDisplayAsBot(boolean displayAsBot) {
        if (this.displayAsBot == displayAsBot) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withUsername(String username) {
        if (this.username.equals(username)) {
            return this;
        }
        String newValue = Objects.requireNonNull(username, "username");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, newValue, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withUrlPrivate(String urlPrivate) {
        if (this.urlPrivate.equals(urlPrivate)) {
            return this;
        }
        String newValue = Objects.requireNonNull(urlPrivate, "urlPrivate");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, newValue, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withUrlPrivateDownload(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.urlPrivateDownload, newValue)) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, newValue, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withUrlPrivateDownload(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.urlPrivateDownload, value)) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, value, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPermalink(String permalink) {
        if (this.permalink.equals(permalink)) {
            return this;
        }
        String newValue = Objects.requireNonNull(permalink, "permalink");
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, newValue, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPermalinkPublic(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.permalinkPublic, newValue)) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, newValue, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withPermalinkPublic(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.permalinkPublic, value)) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, value, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withCommentsCount(int commentsCount) {
        if (this.commentsCount == commentsCount) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withStarred(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.starred, newValue)) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, newValue, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withStarred(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.starred, value)) {
            return this;
        }
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, value, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackTextFile withChannelIds(String ... elements) {
        List<String> newValue = SlackTextFile.createUnmodifiableList(false, SlackTextFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackTextFile withChannelIds(Iterable<String> elements) {
        if (this.channelIds == elements) {
            return this;
        }
        List<String> newValue = SlackTextFile.createUnmodifiableList(false, SlackTextFile.createSafeList(elements, true, false));
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackTextFile withGroupIds(String ... elements) {
        List<String> newValue = SlackTextFile.createUnmodifiableList(false, SlackTextFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackTextFile withGroupIds(Iterable<String> elements) {
        if (this.groupIds == elements) {
            return this;
        }
        List<String> newValue = SlackTextFile.createUnmodifiableList(false, SlackTextFile.createSafeList(elements, true, false));
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackTextFile withImIds(String ... elements) {
        List<String> newValue = SlackTextFile.createUnmodifiableList(false, SlackTextFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public final SlackTextFile withImIds(Iterable<String> elements) {
        if (this.imIds == elements) {
            return this;
        }
        List<String> newValue = SlackTextFile.createUnmodifiableList(false, SlackTextFile.createSafeList(elements, true, false));
        return new SlackTextFile(this.filetype, this.editLink, this.preview, this.previewHighlight, this.lines, this.linesMore, this.previewTruncated, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackTextFile && this.equalTo((SlackTextFile)another);
    }

    private boolean equalTo(SlackTextFile another) {
        return this.filetype.equals((Object)another.filetype) && this.editLink.equals(another.editLink) && this.preview.equals(another.preview) && this.previewHighlight.equals(another.previewHighlight) && this.lines.equals(another.lines) && this.linesMore.equals(another.linesMore) && this.previewTruncated == another.previewTruncated && this.id.equals(another.id) && this.createdEpochSeconds == another.createdEpochSeconds && this.timestampEpochSeconds == another.timestampEpochSeconds && this.name.equals(another.name) && this.title.equals(another.title) && this.mimetype.equals(another.mimetype) && this.prettyType.equals(another.prettyType) && this.userId.equals(another.userId) && this.editable == another.editable && this.size == another.size && this.mode.equals(another.mode) && this.external == another.external && this.isPublic == another.isPublic && this.publicUrlShared == another.publicUrlShared && this.displayAsBot == another.displayAsBot && this.username.equals(another.username) && this.urlPrivate.equals(another.urlPrivate) && Objects.equals(this.urlPrivateDownload, another.urlPrivateDownload) && this.permalink.equals(another.permalink) && Objects.equals(this.permalinkPublic, another.permalinkPublic) && this.commentsCount == another.commentsCount && Objects.equals(this.starred, another.starred) && this.channelIds.equals(another.channelIds) && this.groupIds.equals(another.groupIds) && this.imIds.equals(another.imIds);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.filetype.hashCode();
        h = h * 17 + this.editLink.hashCode();
        h = h * 17 + this.preview.hashCode();
        h = h * 17 + this.previewHighlight.hashCode();
        h = h * 17 + this.lines.hashCode();
        h = h * 17 + this.linesMore.hashCode();
        h = h * 17 + Boolean.hashCode(this.previewTruncated);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Long.hashCode(this.createdEpochSeconds);
        h = h * 17 + Long.hashCode(this.timestampEpochSeconds);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.mimetype.hashCode();
        h = h * 17 + this.prettyType.hashCode();
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + Boolean.hashCode(this.editable);
        h = h * 17 + Long.hashCode(this.size);
        h = h * 17 + this.mode.hashCode();
        h = h * 17 + Boolean.hashCode(this.external);
        h = h * 17 + Boolean.hashCode(this.isPublic);
        h = h * 17 + Boolean.hashCode(this.publicUrlShared);
        h = h * 17 + Boolean.hashCode(this.displayAsBot);
        h = h * 17 + this.username.hashCode();
        h = h * 17 + this.urlPrivate.hashCode();
        h = h * 17 + Objects.hashCode(this.urlPrivateDownload);
        h = h * 17 + this.permalink.hashCode();
        h = h * 17 + Objects.hashCode(this.permalinkPublic);
        h = h * 17 + this.commentsCount;
        h = h * 17 + Objects.hashCode(this.starred);
        h = h * 17 + this.channelIds.hashCode();
        h = h * 17 + this.groupIds.hashCode();
        h = h * 17 + this.imIds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackTextFile{");
        builder.append("filetype=").append((Object)this.filetype);
        builder.append(", ");
        builder.append("editLink=").append(this.editLink);
        builder.append(", ");
        builder.append("preview=").append(this.preview);
        builder.append(", ");
        builder.append("previewHighlight=").append(this.previewHighlight);
        builder.append(", ");
        builder.append("lines=").append(this.lines);
        builder.append(", ");
        builder.append("linesMore=").append(this.linesMore);
        builder.append(", ");
        builder.append("previewTruncated=").append(this.previewTruncated);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("createdEpochSeconds=").append(this.createdEpochSeconds);
        builder.append(", ");
        builder.append("timestampEpochSeconds=").append(this.timestampEpochSeconds);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("mimetype=").append(this.mimetype);
        builder.append(", ");
        builder.append("prettyType=").append(this.prettyType);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("editable=").append(this.editable);
        builder.append(", ");
        builder.append("size=").append(this.size);
        builder.append(", ");
        builder.append("mode=").append(this.mode);
        builder.append(", ");
        builder.append("external=").append(this.external);
        builder.append(", ");
        builder.append("isPublic=").append(this.isPublic);
        builder.append(", ");
        builder.append("publicUrlShared=").append(this.publicUrlShared);
        builder.append(", ");
        builder.append("displayAsBot=").append(this.displayAsBot);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("urlPrivate=").append(this.urlPrivate);
        if (this.urlPrivateDownload != null) {
            builder.append(", ");
            builder.append("urlPrivateDownload=").append(this.urlPrivateDownload);
        }
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        if (this.permalinkPublic != null) {
            builder.append(", ");
            builder.append("permalinkPublic=").append(this.permalinkPublic);
        }
        builder.append(", ");
        builder.append("commentsCount=").append(this.commentsCount);
        if (this.starred != null) {
            builder.append(", ");
            builder.append("starred=").append(this.starred);
        }
        builder.append(", ");
        builder.append("channelIds=").append(this.channelIds);
        builder.append(", ");
        builder.append("groupIds=").append(this.groupIds);
        builder.append(", ");
        builder.append("imIds=").append(this.imIds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackTextFile fromJson(Json json) {
        Builder builder = SlackTextFile.builder();
        if (json.filetype != null) {
            builder.setFiletype(json.filetype);
        }
        if (json.editLink != null) {
            builder.setEditLink(json.editLink);
        }
        if (json.preview != null) {
            builder.setPreview(json.preview);
        }
        if (json.previewHighlight != null) {
            builder.setPreviewHighlight(json.previewHighlight);
        }
        if (json.lines != null) {
            builder.setLines(json.lines);
        }
        if (json.linesMore != null) {
            builder.setLinesMore(json.linesMore);
        }
        if (json.previewTruncatedIsSet) {
            builder.setPreviewTruncated(json.previewTruncated);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.createdEpochSecondsIsSet) {
            builder.setCreatedEpochSeconds(json.createdEpochSeconds);
        }
        if (json.timestampEpochSecondsIsSet) {
            builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.mimetype != null) {
            builder.setMimetype(json.mimetype);
        }
        if (json.prettyType != null) {
            builder.setPrettyType(json.prettyType);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.editableIsSet) {
            builder.setEditable(json.editable);
        }
        if (json.sizeIsSet) {
            builder.setSize(json.size);
        }
        if (json.mode != null) {
            builder.setMode(json.mode);
        }
        if (json.externalIsSet) {
            builder.setExternal(json.external);
        }
        if (json.isPublicIsSet) {
            builder.setIsPublic(json.isPublic);
        }
        if (json.publicUrlSharedIsSet) {
            builder.setPublicUrlShared(json.publicUrlShared);
        }
        if (json.displayAsBotIsSet) {
            builder.setDisplayAsBot(json.displayAsBot);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.urlPrivate != null) {
            builder.setUrlPrivate(json.urlPrivate);
        }
        if (json.urlPrivateDownload != null) {
            builder.setUrlPrivateDownload(json.urlPrivateDownload);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.permalinkPublic != null) {
            builder.setPermalinkPublic(json.permalinkPublic);
        }
        if (json.commentsCountIsSet) {
            builder.setCommentsCount(json.commentsCount);
        }
        if (json.starred != null) {
            builder.setStarred(json.starred);
        }
        if (json.channelIds != null) {
            builder.addAllChannelIds(json.channelIds);
        }
        if (json.groupIds != null) {
            builder.addAllGroupIds(json.groupIds);
        }
        if (json.imIds != null) {
            builder.addAllImIds(json.imIds);
        }
        return builder.build();
    }

    public static SlackTextFile copyOf(SlackTextFileIF instance) {
        if (instance instanceof SlackTextFile) {
            return (SlackTextFile)instance;
        }
        return SlackTextFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EDIT_LINK = 1L;
        private static final long INIT_BIT_PREVIEW = 2L;
        private static final long INIT_BIT_PREVIEW_HIGHLIGHT = 4L;
        private static final long INIT_BIT_LINES = 8L;
        private static final long INIT_BIT_LINES_MORE = 16L;
        private static final long INIT_BIT_PREVIEW_TRUNCATED = 32L;
        private static final long INIT_BIT_ID = 64L;
        private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 128L;
        private static final long INIT_BIT_TIMESTAMP_EPOCH_SECONDS = 256L;
        private static final long INIT_BIT_NAME = 512L;
        private static final long INIT_BIT_TITLE = 1024L;
        private static final long INIT_BIT_MIMETYPE = 2048L;
        private static final long INIT_BIT_PRETTY_TYPE = 4096L;
        private static final long INIT_BIT_USER_ID = 8192L;
        private static final long INIT_BIT_EDITABLE = 16384L;
        private static final long INIT_BIT_SIZE = 32768L;
        private static final long INIT_BIT_MODE = 65536L;
        private static final long INIT_BIT_EXTERNAL = 131072L;
        private static final long INIT_BIT_IS_PUBLIC = 262144L;
        private static final long INIT_BIT_PUBLIC_URL_SHARED = 524288L;
        private static final long INIT_BIT_DISPLAY_AS_BOT = 0x100000L;
        private static final long INIT_BIT_USERNAME = 0x200000L;
        private static final long INIT_BIT_URL_PRIVATE = 0x400000L;
        private static final long INIT_BIT_PERMALINK = 0x800000L;
        private static final long OPT_BIT_COMMENTS_COUNT = 1L;
        private long initBits = 0xFFFFFFL;
        private long optBits;
        @Nullable
        private SlackFileType filetype;
        @Nullable
        private String editLink;
        @Nullable
        private String preview;
        @Nullable
        private String previewHighlight;
        @Nullable
        private String lines;
        @Nullable
        private String linesMore;
        private boolean previewTruncated;
        @Nullable
        private String id;
        private long createdEpochSeconds;
        private long timestampEpochSeconds;
        @Nullable
        private String name;
        @Nullable
        private String title;
        @Nullable
        private String mimetype;
        @Nullable
        private String prettyType;
        @Nullable
        private String userId;
        private boolean editable;
        private long size;
        @Nullable
        private String mode;
        private boolean external;
        private boolean isPublic;
        private boolean publicUrlShared;
        private boolean displayAsBot;
        @Nullable
        private String username;
        @Nullable
        private String urlPrivate;
        @Nullable
        private String urlPrivateDownload;
        @Nullable
        private String permalink;
        @Nullable
        private String permalinkPublic;
        private int commentsCount;
        @Nullable
        private Boolean starred;
        private List<String> channelIds = new ArrayList<String>();
        private List<String> groupIds = new ArrayList<String>();
        private List<String> imIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(SlackTextFileCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackTextFileIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackFile instance;
            long bits = 0L;
            if (object instanceof SlackTextFileCore) {
                instance = (SlackTextFileCore)object;
                this.setPreview(instance.getPreview());
                this.setPreviewHighlight(instance.getPreviewHighlight());
                this.setLines(instance.getLines());
                this.setEditLink(instance.getEditLink());
                this.setLinesMore(instance.getLinesMore());
                this.setPreviewTruncated(instance.isPreviewTruncated());
            }
            if (object instanceof SlackFile) {
                instance = (SlackFile)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                this.setTitle(instance.getTitle());
                this.setDisplayAsBot(instance.getDisplayAsBot());
                this.addAllImIds(instance.getImIds());
                Optional<String> urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                if (urlPrivateDownloadOptional.isPresent()) {
                    this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                }
                this.setMode(instance.getMode());
                Optional<Boolean> starredOptional = instance.isStarred();
                if (starredOptional.isPresent()) {
                    this.setStarred(starredOptional);
                }
                this.setUrlPrivate(instance.getUrlPrivate());
                this.setPrettyType(instance.getPrettyType());
                this.addAllGroupIds(instance.getGroupIds());
                this.setPublicUrlShared(instance.isPublicUrlShared());
                this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                this.setIsPublic(instance.isPublic());
                this.setId(instance.getId());
                this.addAllChannelIds(instance.getChannelIds());
                this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                this.setEditable(instance.isEditable());
                this.setUserId(instance.getUserId());
                this.setExternal(instance.isExternal());
                this.setSize(instance.getSize());
                this.setCommentsCount(instance.getCommentsCount());
                this.setName(instance.getName());
                this.setMimetype(instance.getMimetype());
                Optional<String> permalinkPublicOptional = instance.getPermalinkPublic();
                if (permalinkPublicOptional.isPresent()) {
                    this.setPermalinkPublic(permalinkPublicOptional);
                }
                this.setPermalink(instance.getPermalink());
                this.setUsername(instance.getUsername());
            }
            if (object instanceof SlackTextFileIF) {
                instance = (SlackTextFileIF)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
            }
        }

        public final Builder setFiletype(SlackFileType filetype) {
            this.filetype = Objects.requireNonNull(filetype, "filetype");
            return this;
        }

        public final Builder setEditLink(String editLink) {
            this.editLink = Objects.requireNonNull(editLink, "editLink");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPreview(String preview) {
            this.preview = Objects.requireNonNull(preview, "preview");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPreviewHighlight(String previewHighlight) {
            this.previewHighlight = Objects.requireNonNull(previewHighlight, "previewHighlight");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setLines(String lines) {
            this.lines = Objects.requireNonNull(lines, "lines");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setLinesMore(String linesMore) {
            this.linesMore = Objects.requireNonNull(linesMore, "linesMore");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setPreviewTruncated(boolean previewTruncated) {
            this.previewTruncated = previewTruncated;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder setMimetype(String mimetype) {
            this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder setPrettyType(String prettyType) {
            this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder setEditable(boolean editable) {
            this.editable = editable;
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        public final Builder setSize(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public final Builder setMode(String mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public final Builder setExternal(boolean external) {
            this.external = external;
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        public final Builder setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        public final Builder setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.initBits &= 0xFFFFFFFFFFF7FFFFL;
            return this;
        }

        public final Builder setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.initBits &= 0xFFFFFFFFFFEFFFFFL;
            return this;
        }

        public final Builder setUsername(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFDFFFFFL;
            return this;
        }

        public final Builder setUrlPrivate(String urlPrivate) {
            this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
            this.initBits &= 0xFFFFFFFFFFBFFFFFL;
            return this;
        }

        public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
            return this;
        }

        public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload.orElse(null);
            return this;
        }

        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            this.initBits &= 0xFFFFFFFFFF7FFFFFL;
            return this;
        }

        public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
            return this;
        }

        public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic.orElse(null);
            return this;
        }

        public final Builder setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setStarred(@Nullable Boolean starred) {
            this.starred = starred;
            return this;
        }

        public final Builder setStarred(Optional<Boolean> starred) {
            this.starred = starred.orElse(null);
            return this;
        }

        public final Builder addChannelIds(String element) {
            this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            return this;
        }

        public final Builder addChannelIds(String ... elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder setChannelIds(Iterable<String> elements) {
            this.channelIds.clear();
            return this.addAllChannelIds(elements);
        }

        public final Builder addAllChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder addGroupIds(String element) {
            this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            return this;
        }

        public final Builder addGroupIds(String ... elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder setGroupIds(Iterable<String> elements) {
            this.groupIds.clear();
            return this.addAllGroupIds(elements);
        }

        public final Builder addAllGroupIds(Iterable<String> elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder addImIds(String element) {
            this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            return this;
        }

        public final Builder addImIds(String ... elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public final Builder setImIds(Iterable<String> elements) {
            this.imIds.clear();
            return this.addAllImIds(elements);
        }

        public final Builder addAllImIds(Iterable<String> elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public SlackTextFile build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackTextFile(this);
        }

        private boolean commentsCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean editLinkIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean previewIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean previewHighlightIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean linesIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean linesMoreIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean previewTruncatedIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean createdEpochSecondsIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean timestampEpochSecondsIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 0x400L) == 0L;
        }

        private boolean mimetypeIsSet() {
            return (this.initBits & 0x800L) == 0L;
        }

        private boolean prettyTypeIsSet() {
            return (this.initBits & 0x1000L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 0x2000L) == 0L;
        }

        private boolean editableIsSet() {
            return (this.initBits & 0x4000L) == 0L;
        }

        private boolean sizeIsSet() {
            return (this.initBits & 0x8000L) == 0L;
        }

        private boolean modeIsSet() {
            return (this.initBits & 0x10000L) == 0L;
        }

        private boolean externalIsSet() {
            return (this.initBits & 0x20000L) == 0L;
        }

        private boolean isPublicIsSet() {
            return (this.initBits & 0x40000L) == 0L;
        }

        private boolean publicUrlSharedIsSet() {
            return (this.initBits & 0x80000L) == 0L;
        }

        private boolean displayAsBotIsSet() {
            return (this.initBits & 0x100000L) == 0L;
        }

        private boolean usernameIsSet() {
            return (this.initBits & 0x200000L) == 0L;
        }

        private boolean urlPrivateIsSet() {
            return (this.initBits & 0x400000L) == 0L;
        }

        private boolean permalinkIsSet() {
            return (this.initBits & 0x800000L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.editLinkIsSet()) {
                attributes.add("editLink");
            }
            if (!this.previewIsSet()) {
                attributes.add("preview");
            }
            if (!this.previewHighlightIsSet()) {
                attributes.add("previewHighlight");
            }
            if (!this.linesIsSet()) {
                attributes.add("lines");
            }
            if (!this.linesMoreIsSet()) {
                attributes.add("linesMore");
            }
            if (!this.previewTruncatedIsSet()) {
                attributes.add("previewTruncated");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.createdEpochSecondsIsSet()) {
                attributes.add("createdEpochSeconds");
            }
            if (!this.timestampEpochSecondsIsSet()) {
                attributes.add("timestampEpochSeconds");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.mimetypeIsSet()) {
                attributes.add("mimetype");
            }
            if (!this.prettyTypeIsSet()) {
                attributes.add("prettyType");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.editableIsSet()) {
                attributes.add("editable");
            }
            if (!this.sizeIsSet()) {
                attributes.add("size");
            }
            if (!this.modeIsSet()) {
                attributes.add("mode");
            }
            if (!this.externalIsSet()) {
                attributes.add("external");
            }
            if (!this.isPublicIsSet()) {
                attributes.add("isPublic");
            }
            if (!this.publicUrlSharedIsSet()) {
                attributes.add("publicUrlShared");
            }
            if (!this.displayAsBotIsSet()) {
                attributes.add("displayAsBot");
            }
            if (!this.usernameIsSet()) {
                attributes.add("username");
            }
            if (!this.urlPrivateIsSet()) {
                attributes.add("urlPrivate");
            }
            if (!this.permalinkIsSet()) {
                attributes.add("permalink");
            }
            return "Cannot build SlackTextFile, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackTextFileIF {
        @Nullable
        SlackFileType filetype;
        @Nullable
        String editLink;
        @Nullable
        String preview;
        @Nullable
        String previewHighlight;
        @Nullable
        String lines;
        @Nullable
        String linesMore;
        boolean previewTruncated;
        boolean previewTruncatedIsSet;
        @Nullable
        String id;
        long createdEpochSeconds;
        boolean createdEpochSecondsIsSet;
        long timestampEpochSeconds;
        boolean timestampEpochSecondsIsSet;
        @Nullable
        String name;
        @Nullable
        String title;
        @Nullable
        String mimetype;
        @Nullable
        String prettyType;
        @Nullable
        String userId;
        boolean editable;
        boolean editableIsSet;
        long size;
        boolean sizeIsSet;
        @Nullable
        String mode;
        boolean external;
        boolean externalIsSet;
        boolean isPublic;
        boolean isPublicIsSet;
        boolean publicUrlShared;
        boolean publicUrlSharedIsSet;
        boolean displayAsBot;
        boolean displayAsBotIsSet;
        @Nullable
        String username;
        @Nullable
        String urlPrivate;
        Optional<String> urlPrivateDownload = Optional.empty();
        @Nullable
        String permalink;
        Optional<String> permalinkPublic = Optional.empty();
        int commentsCount;
        boolean commentsCountIsSet;
        Optional<Boolean> starred = Optional.empty();
        List<String> channelIds = Collections.emptyList();
        List<String> groupIds = Collections.emptyList();
        List<String> imIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
        }

        @JsonProperty
        public void setEditLink(String editLink) {
            this.editLink = editLink;
        }

        @JsonProperty
        public void setPreview(String preview) {
            this.preview = preview;
        }

        @JsonProperty
        public void setPreviewHighlight(String previewHighlight) {
            this.previewHighlight = previewHighlight;
        }

        @JsonProperty
        public void setLines(String lines) {
            this.lines = lines;
        }

        @JsonProperty
        public void setLinesMore(String linesMore) {
            this.linesMore = linesMore;
        }

        @JsonProperty(value="preview_is_truncated")
        public void setPreviewTruncated(boolean previewTruncated) {
            this.previewTruncated = previewTruncated;
            this.previewTruncatedIsSet = true;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="created")
        public void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsIsSet = true;
        }

        @JsonProperty(value="timestamp")
        public void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        @JsonProperty
        public void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setEditable(boolean editable) {
            this.editable = editable;
            this.editableIsSet = true;
        }

        @JsonProperty
        public void setSize(long size) {
            this.size = size;
            this.sizeIsSet = true;
        }

        @JsonProperty
        public void setMode(String mode) {
            this.mode = mode;
        }

        @JsonProperty(value="is_external")
        public void setExternal(boolean external) {
            this.external = external;
            this.externalIsSet = true;
        }

        @JsonProperty(value="is_public")
        public void setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicIsSet = true;
        }

        @JsonProperty
        public void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedIsSet = true;
        }

        @JsonProperty
        public void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotIsSet = true;
        }

        @JsonProperty
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty
        public void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
        }

        @JsonProperty
        public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
        }

        @JsonProperty
        public void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountIsSet = true;
        }

        @JsonProperty(value="is_starred")
        public void setStarred(Optional<Boolean> starred) {
            this.starred = starred;
        }

        @JsonProperty(value="channels")
        public void setChannelIds(List<String> channelIds) {
            this.channelIds = channelIds;
        }

        @JsonProperty(value="groups")
        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        @JsonProperty(value="ims")
        public void setImIds(List<String> imIds) {
            this.imIds = imIds;
        }

        @Override
        public SlackFileType getFiletype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEditLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPreview() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPreviewHighlight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLines() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLinesMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPreviewTruncated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTimestampEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMimetype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrettyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEditable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublicUrlShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDisplayAsBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrlPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrlPrivateDownload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPermalinkPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCommentsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isStarred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getImIds() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private SlackFileType filetype;
        private int filetypeStage;
        private int commentsCount;
        private int commentsCountStage;

        private InitShim() {
        }

        SlackFileType getFiletype() {
            if (this.filetypeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.filetypeStage == 0) {
                this.filetypeStage = -1;
                this.filetype = Objects.requireNonNull(SlackTextFile.this.getFiletypeInitialize(), "filetype");
                this.filetypeStage = 1;
            }
            return this.filetype;
        }

        void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
            this.filetypeStage = 1;
        }

        int getCommentsCount() {
            if (this.commentsCountStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.commentsCountStage == 0) {
                this.commentsCountStage = -1;
                this.commentsCount = SlackTextFile.this.getCommentsCountInitialize();
                this.commentsCountStage = 1;
            }
            return this.commentsCount;
        }

        void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filetypeStage == -1) {
                attributes.add("filetype");
            }
            if (this.commentsCountStage == -1) {
                attributes.add("commentsCount");
            }
            return "Cannot build SlackTextFile, attribute initializers form cycle" + attributes;
        }
    }
}

