/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.SlackErrorIF;
import com.hubspot.slack.client.models.response.SlackErrorType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackError
implements SlackErrorIF {
    private final SlackErrorType type;
    private final String error;

    private SlackError(String error) {
        this.error = Objects.requireNonNull(error, "error");
        this.type = Objects.requireNonNull(SlackErrorIF.super.getType(), "type");
    }

    private SlackError(Builder builder) {
        this.error = builder.error;
        this.type = builder.type != null ? builder.type : Objects.requireNonNull(SlackErrorIF.super.getType(), "type");
    }

    private SlackError(SlackErrorType type, String error) {
        this.type = type;
        this.error = error;
    }

    @Override
    @JsonProperty
    public SlackErrorType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getError() {
        return this.error;
    }

    public final SlackError withType(SlackErrorType type) {
        if (this.type == type) {
            return this;
        }
        SlackErrorType newValue = Objects.requireNonNull(type, "type");
        return new SlackError(newValue, this.error);
    }

    public final SlackError withError(String error) {
        if (this.error.equals(error)) {
            return this;
        }
        String newValue = Objects.requireNonNull(error, "error");
        return new SlackError(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackError && this.equalTo((SlackError)another);
    }

    private boolean equalTo(SlackError another) {
        return this.type.equals((Object)another.type) && this.error.equals(another.error);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.error.hashCode();
        return h;
    }

    public String toString() {
        return "SlackError{type=" + (Object)((Object)this.type) + ", error=" + this.error + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackError fromJson(Json json) {
        Builder builder = SlackError.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.error != null) {
            builder.setError(json.error);
        }
        return builder.build();
    }

    public static SlackError of(String error) {
        return new SlackError(error);
    }

    public static SlackError copyOf(SlackErrorIF instance) {
        if (instance instanceof SlackError) {
            return (SlackError)instance;
        }
        return SlackError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ERROR = 1L;
        private long initBits = 1L;
        @Nullable
        private SlackErrorType type;
        @Nullable
        private String error;

        private Builder() {
        }

        public final Builder from(SlackErrorIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            this.setError(instance.getError());
            return this;
        }

        public final Builder setType(SlackErrorType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public final Builder setError(String error) {
            this.error = Objects.requireNonNull(error, "error");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public SlackError build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackError(this);
        }

        private boolean errorIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.errorIsSet()) {
                attributes.add("error");
            }
            return "Cannot build SlackError, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackErrorIF {
        @Nullable
        SlackErrorType type;
        @Nullable
        String error;

        Json() {
        }

        @JsonProperty
        public void setType(SlackErrorType type) {
            this.type = type;
        }

        @JsonProperty
        public void setError(String error) {
            this.error = error;
        }

        @Override
        public SlackErrorType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }
    }
}

