/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChannelsListResponse
implements ChannelsListResponseIF {
    private final List<SlackChannel> channels;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ChannelsListResponse(List<SlackChannel> channels, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.channels = channels;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public List<SlackChannel> getChannels() {
        return this.channels;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ChannelsListResponse withChannels(SlackChannel ... elements) {
        List<SlackChannel> newValue = ChannelsListResponse.createUnmodifiableList(false, ChannelsListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ChannelsListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final ChannelsListResponse withChannels(Iterable<? extends SlackChannel> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<SlackChannel> newValue = ChannelsListResponse.createUnmodifiableList(false, ChannelsListResponse.createSafeList(elements, true, false));
        return new ChannelsListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final ChannelsListResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ChannelsListResponse(this.channels, ok, this.responseMetadata);
    }

    public final ChannelsListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChannelsListResponse(this.channels, this.ok, newValue);
    }

    public final ChannelsListResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChannelsListResponse(this.channels, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsListResponse && this.equalTo((ChannelsListResponse)another);
    }

    private boolean equalTo(ChannelsListResponse another) {
        return this.channels.equals(another.channels) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channels.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsListResponse{");
        builder.append("channels=").append(this.channels);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChannelsListResponse fromJson(Json json) {
        Builder builder = ChannelsListResponse.builder();
        if (json.channels != null) {
            builder.addAllChannels(json.channels);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ChannelsListResponse copyOf(ChannelsListResponseIF instance) {
        if (instance instanceof ChannelsListResponse) {
            return (ChannelsListResponse)instance;
        }
        return ChannelsListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private List<SlackChannel> channels = new ArrayList<SlackChannel>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(ChannelsListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof ChannelsListResponseIF) {
                instance = (ChannelsListResponseIF)object;
                this.addAllChannels(instance.getChannels());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder addChannels(SlackChannel element) {
            this.channels.add(Objects.requireNonNull(element, "channels element"));
            return this;
        }

        public final Builder addChannels(SlackChannel ... elements) {
            for (SlackChannel element : elements) {
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            return this;
        }

        public final Builder setChannels(Iterable<? extends SlackChannel> elements) {
            this.channels.clear();
            return this.addAllChannels(elements);
        }

        public final Builder addAllChannels(Iterable<? extends SlackChannel> elements) {
            for (SlackChannel slackChannel : elements) {
                this.channels.add(Objects.requireNonNull(slackChannel, "channels element"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ChannelsListResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChannelsListResponse(ChannelsListResponse.createUnmodifiableList(true, this.channels), this.ok, this.responseMetadata);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChannelsListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChannelsListResponseIF {
        List<SlackChannel> channels = Collections.emptyList();
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setChannels(List<SlackChannel> channels) {
            this.channels = channels;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public List<SlackChannel> getChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

