/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatUpdateMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChatUpdateMessageResponse
implements ChatUpdateMessageResponseIF {
    private final String ts;
    private final String channel;
    private final String text;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ChatUpdateMessageResponse(String ts, String channel, String text, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.ts = ts;
        this.channel = channel;
        this.text = text;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ChatUpdateMessageResponse withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new ChatUpdateMessageResponse(newValue, this.channel, this.text, this.ok, this.responseMetadata);
    }

    public final ChatUpdateMessageResponse withChannel(String channel) {
        if (this.channel.equals(channel)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channel, "channel");
        return new ChatUpdateMessageResponse(this.ts, newValue, this.text, this.ok, this.responseMetadata);
    }

    public final ChatUpdateMessageResponse withText(String text) {
        if (this.text.equals(text)) {
            return this;
        }
        String newValue = Objects.requireNonNull(text, "text");
        return new ChatUpdateMessageResponse(this.ts, this.channel, newValue, this.ok, this.responseMetadata);
    }

    public final ChatUpdateMessageResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, ok, this.responseMetadata);
    }

    public final ChatUpdateMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, this.ok, newValue);
    }

    public final ChatUpdateMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatUpdateMessageResponse && this.equalTo((ChatUpdateMessageResponse)another);
    }

    private boolean equalTo(ChatUpdateMessageResponse another) {
        return this.ts.equals(another.ts) && this.channel.equals(another.channel) && this.text.equals(another.text) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.ts.hashCode();
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + this.text.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatUpdateMessageResponse{");
        builder.append("ts=").append(this.ts);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChatUpdateMessageResponse fromJson(Json json) {
        Builder builder = ChatUpdateMessageResponse.builder();
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ChatUpdateMessageResponse copyOf(ChatUpdateMessageResponseIF instance) {
        if (instance instanceof ChatUpdateMessageResponse) {
            return (ChatUpdateMessageResponse)instance;
        }
        return ChatUpdateMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TS = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private static final long INIT_BIT_TEXT = 4L;
        private static final long INIT_BIT_OK = 8L;
        private long initBits = 15L;
        @Nullable
        private String ts;
        @Nullable
        private String channel;
        @Nullable
        private String text;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatUpdateMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ChatUpdateMessageResponseIF) {
                instance = (ChatUpdateMessageResponseIF)object;
                this.setChannel(instance.getChannel());
                this.setText(instance.getText());
                this.setTs(instance.getTs());
            }
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ChatUpdateMessageResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, this.ok, this.responseMetadata);
        }

        private boolean tsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChatUpdateMessageResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChatUpdateMessageResponseIF {
        @Nullable
        String ts;
        @Nullable
        String channel;
        @Nullable
        String text;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

