/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.emoji;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.emoji.EmojiListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class EmojiListResponse
implements EmojiListResponseIF {
    private final Map<String, String> emoji;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private EmojiListResponse(Map<String, String> emoji, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.emoji = emoji;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public Map<String, String> getEmoji() {
        return this.emoji;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final EmojiListResponse withEmoji(Map<String, ? extends String> emoji) {
        if (this.emoji == emoji) {
            return this;
        }
        Map<String, String> newValue = EmojiListResponse.createUnmodifiableMap(true, false, emoji);
        return new EmojiListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final EmojiListResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new EmojiListResponse(this.emoji, ok, this.responseMetadata);
    }

    public final EmojiListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new EmojiListResponse(this.emoji, this.ok, newValue);
    }

    public final EmojiListResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new EmojiListResponse(this.emoji, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmojiListResponse && this.equalTo((EmojiListResponse)another);
    }

    private boolean equalTo(EmojiListResponse another) {
        return this.emoji.equals(another.emoji) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.emoji.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EmojiListResponse{");
        builder.append("emoji=").append(this.emoji);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static EmojiListResponse fromJson(Json json) {
        Builder builder = EmojiListResponse.builder();
        if (json.emoji != null) {
            builder.putAllEmoji(json.emoji);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static EmojiListResponse copyOf(EmojiListResponseIF instance) {
        if (instance instanceof EmojiListResponse) {
            return (EmojiListResponse)instance;
        }
        return EmojiListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private Map<String, String> emoji = new LinkedHashMap<String, String>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmojiListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof EmojiListResponseIF) {
                instance = (EmojiListResponseIF)object;
                this.putAllEmoji(instance.getEmoji());
            }
        }

        public final Builder putEmoji(String key, String value) {
            this.emoji.put(Objects.requireNonNull(key, "emoji key"), Objects.requireNonNull(value, "emoji value"));
            return this;
        }

        public final Builder putEmoji(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.emoji.put(Objects.requireNonNull(k, "emoji key"), Objects.requireNonNull(v, "emoji value"));
            return this;
        }

        public final Builder setEmoji(Map<String, ? extends String> emoji) {
            this.emoji.clear();
            return this.putAllEmoji(emoji);
        }

        public final Builder putAllEmoji(Map<String, ? extends String> emoji) {
            for (Map.Entry<String, ? extends String> entry : emoji.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.emoji.put(Objects.requireNonNull(k, "emoji key"), Objects.requireNonNull(v, "emoji value"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public EmojiListResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new EmojiListResponse(EmojiListResponse.createUnmodifiableMap(false, false, this.emoji), this.ok, this.responseMetadata);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build EmojiListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EmojiListResponseIF {
        @Nullable
        Map<String, String> emoji;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setEmoji(Map<String, String> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public Map<String, String> getEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

