/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.im;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.channel.ImChannel;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.im.ImOpenResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImOpenResponse
implements ImOpenResponseIF {
    private final boolean noOp;
    private final boolean alreadyOpen;
    @Nullable
    private final ImChannel channel;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImOpenResponse(Builder builder) {
        this.channel = builder.channel;
        this.ok = builder.ok;
        this.responseMetadata = builder.responseMetadata;
        if (builder.noOpIsSet()) {
            this.initShim.setNoOp(builder.noOp);
        }
        if (builder.alreadyOpenIsSet()) {
            this.initShim.setAlreadyOpen(builder.alreadyOpen);
        }
        this.noOp = this.initShim.isNoOp();
        this.alreadyOpen = this.initShim.isAlreadyOpen();
        this.initShim = null;
    }

    private ImOpenResponse(boolean noOp, boolean alreadyOpen, @Nullable ImChannel channel, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.noOp = noOp;
        this.alreadyOpen = alreadyOpen;
        this.channel = channel;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.initShim = null;
    }

    private boolean isNoOpInitialize() {
        return ImOpenResponseIF.super.isNoOp();
    }

    private boolean isAlreadyOpenInitialize() {
        return ImOpenResponseIF.super.isAlreadyOpen();
    }

    @Override
    @JsonProperty
    public boolean isNoOp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isNoOp() : this.noOp;
    }

    @Override
    @JsonProperty
    public boolean isAlreadyOpen() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAlreadyOpen() : this.alreadyOpen;
    }

    @Override
    @JsonProperty
    public Optional<ImChannel> getChannel() {
        return Optional.ofNullable(this.channel);
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ImOpenResponse withNoOp(boolean noOp) {
        if (this.noOp == noOp) {
            return this;
        }
        return new ImOpenResponse(noOp, this.alreadyOpen, this.channel, this.ok, this.responseMetadata);
    }

    public final ImOpenResponse withAlreadyOpen(boolean alreadyOpen) {
        if (this.alreadyOpen == alreadyOpen) {
            return this;
        }
        return new ImOpenResponse(this.noOp, alreadyOpen, this.channel, this.ok, this.responseMetadata);
    }

    public final ImOpenResponse withChannel(@Nullable ImChannel value) {
        ImChannel newValue = value;
        if (this.channel == newValue) {
            return this;
        }
        return new ImOpenResponse(this.noOp, this.alreadyOpen, newValue, this.ok, this.responseMetadata);
    }

    public final ImOpenResponse withChannel(Optional<ImChannel> optional) {
        ImChannel value = optional.orElse(null);
        if (this.channel == value) {
            return this;
        }
        return new ImOpenResponse(this.noOp, this.alreadyOpen, value, this.ok, this.responseMetadata);
    }

    public final ImOpenResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ImOpenResponse(this.noOp, this.alreadyOpen, this.channel, ok, this.responseMetadata);
    }

    public final ImOpenResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ImOpenResponse(this.noOp, this.alreadyOpen, this.channel, this.ok, newValue);
    }

    public final ImOpenResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ImOpenResponse(this.noOp, this.alreadyOpen, this.channel, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImOpenResponse && this.equalTo((ImOpenResponse)another);
    }

    private boolean equalTo(ImOpenResponse another) {
        return this.noOp == another.noOp && this.alreadyOpen == another.alreadyOpen && Objects.equals(this.channel, another.channel) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Boolean.hashCode(this.noOp);
        h = h * 17 + Boolean.hashCode(this.alreadyOpen);
        h = h * 17 + Objects.hashCode(this.channel);
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ImOpenResponse{");
        builder.append("noOp=").append(this.noOp);
        builder.append(", ");
        builder.append("alreadyOpen=").append(this.alreadyOpen);
        if (this.channel != null) {
            builder.append(", ");
            builder.append("channel=").append(this.channel);
        }
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ImOpenResponse fromJson(Json json) {
        Builder builder = ImOpenResponse.builder();
        if (json.noOpIsSet) {
            builder.setNoOp(json.noOp);
        }
        if (json.alreadyOpenIsSet) {
            builder.setAlreadyOpen(json.alreadyOpen);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ImOpenResponse copyOf(ImOpenResponseIF instance) {
        if (instance instanceof ImOpenResponse) {
            return (ImOpenResponse)instance;
        }
        return ImOpenResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long OPT_BIT_NO_OP = 1L;
        private static final long OPT_BIT_ALREADY_OPEN = 2L;
        private long initBits = 1L;
        private long optBits;
        private boolean noOp;
        private boolean alreadyOpen;
        @Nullable
        private ImChannel channel;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ImOpenResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ImOpenResponseIF) {
                instance = (ImOpenResponseIF)object;
                Optional<ImChannel> channelOptional = instance.getChannel();
                if (channelOptional.isPresent()) {
                    this.setChannel(channelOptional);
                }
                this.setNoOp(instance.isNoOp());
                this.setAlreadyOpen(instance.isAlreadyOpen());
            }
        }

        public final Builder setNoOp(boolean noOp) {
            this.noOp = noOp;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setAlreadyOpen(boolean alreadyOpen) {
            this.alreadyOpen = alreadyOpen;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setChannel(@Nullable ImChannel channel) {
            this.channel = channel;
            return this;
        }

        public final Builder setChannel(Optional<ImChannel> channel) {
            this.channel = channel.orElse(null);
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ImOpenResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ImOpenResponse(this);
        }

        private boolean noOpIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean alreadyOpenIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ImOpenResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ImOpenResponseIF {
        boolean noOp;
        boolean noOpIsSet;
        boolean alreadyOpen;
        boolean alreadyOpenIsSet;
        Optional<ImChannel> channel = Optional.empty();
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setNoOp(boolean noOp) {
            this.noOp = noOp;
            this.noOpIsSet = true;
        }

        @JsonProperty
        public void setAlreadyOpen(boolean alreadyOpen) {
            this.alreadyOpen = alreadyOpen;
            this.alreadyOpenIsSet = true;
        }

        @JsonProperty
        public void setChannel(Optional<ImChannel> channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public boolean isNoOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAlreadyOpen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ImChannel> getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private boolean noOp;
        private int noOpStage;
        private boolean alreadyOpen;
        private int alreadyOpenStage;

        private InitShim() {
        }

        boolean isNoOp() {
            if (this.noOpStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.noOpStage == 0) {
                this.noOpStage = -1;
                this.noOp = ImOpenResponse.this.isNoOpInitialize();
                this.noOpStage = 1;
            }
            return this.noOp;
        }

        void setNoOp(boolean noOp) {
            this.noOp = noOp;
            this.noOpStage = 1;
        }

        boolean isAlreadyOpen() {
            if (this.alreadyOpenStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.alreadyOpenStage == 0) {
                this.alreadyOpenStage = -1;
                this.alreadyOpen = ImOpenResponse.this.isAlreadyOpenInitialize();
                this.alreadyOpenStage = 1;
            }
            return this.alreadyOpen;
        }

        void setAlreadyOpen(boolean alreadyOpen) {
            this.alreadyOpen = alreadyOpen;
            this.alreadyOpenStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.noOpStage == -1) {
                attributes.add("noOp");
            }
            if (this.alreadyOpenStage == -1) {
                attributes.add("alreadyOpen");
            }
            return "Cannot build ImOpenResponse, attribute initializers form cycle" + attributes;
        }
    }
}

