/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.MessagePage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.search.SearchMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SearchMessageResponse
implements SearchMessageResponseIF {
    private final String query;
    private final MessagePage messages;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private SearchMessageResponse(String query, MessagePage messages, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.query = query;
        this.messages = messages;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @Override
    @JsonProperty
    public MessagePage getMessages() {
        return this.messages;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final SearchMessageResponse withQuery(String query) {
        if (this.query.equals(query)) {
            return this;
        }
        String newValue = Objects.requireNonNull(query, "query");
        return new SearchMessageResponse(newValue, this.messages, this.ok, this.responseMetadata);
    }

    public final SearchMessageResponse withMessages(MessagePage messages) {
        if (this.messages == messages) {
            return this;
        }
        MessagePage newValue = Objects.requireNonNull(messages, "messages");
        return new SearchMessageResponse(this.query, newValue, this.ok, this.responseMetadata);
    }

    public final SearchMessageResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new SearchMessageResponse(this.query, this.messages, ok, this.responseMetadata);
    }

    public final SearchMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new SearchMessageResponse(this.query, this.messages, this.ok, newValue);
    }

    public final SearchMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new SearchMessageResponse(this.query, this.messages, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SearchMessageResponse && this.equalTo((SearchMessageResponse)another);
    }

    private boolean equalTo(SearchMessageResponse another) {
        return this.query.equals(another.query) && this.messages.equals(another.messages) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.query.hashCode();
        h = h * 17 + this.messages.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SearchMessageResponse{");
        builder.append("query=").append(this.query);
        builder.append(", ");
        builder.append("messages=").append(this.messages);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SearchMessageResponse fromJson(Json json) {
        Builder builder = SearchMessageResponse.builder();
        if (json.query != null) {
            builder.setQuery(json.query);
        }
        if (json.messages != null) {
            builder.setMessages(json.messages);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static SearchMessageResponse copyOf(SearchMessageResponseIF instance) {
        if (instance instanceof SearchMessageResponse) {
            return (SearchMessageResponse)instance;
        }
        return SearchMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long INIT_BIT_MESSAGES = 2L;
        private static final long INIT_BIT_OK = 4L;
        private long initBits = 7L;
        @Nullable
        private String query;
        @Nullable
        private MessagePage messages;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SearchMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SearchMessageResponseIF) {
                instance = (SearchMessageResponseIF)object;
                this.setMessages(instance.getMessages());
                this.setQuery(instance.getQuery());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder setQuery(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMessages(MessagePage messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public SearchMessageResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SearchMessageResponse(this.query, this.messages, this.ok, this.responseMetadata);
        }

        private boolean queryIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messagesIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.queryIsSet()) {
                attributes.add("query");
            }
            if (!this.messagesIsSet()) {
                attributes.add("messages");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build SearchMessageResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SearchMessageResponseIF {
        @Nullable
        String query;
        @Nullable
        MessagePage messages;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setQuery(String query) {
            this.query = query;
        }

        @JsonProperty
        public void setMessages(MessagePage messages) {
            this.messages = messages;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public String getQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessagePage getMessages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

